/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssBackground;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundPosition
extends CssProperty {
    private static final String propertyName = "background-position";
    private static HashMap<String, CssIdent> allowed_values;
    private static final CssIdent center;
    private static final CssIdent top;
    private static final CssIdent bottom;
    private static final CssIdent left;
    private static final CssIdent right;
    private static final CssPercentage defaultPercent0;
    private static final CssPercentage defaultPercent50;
    private static final CssPercentage defaultPercent100;
    Object value;

    public static boolean isMatchingIdent(CssIdent ident) {
        return allowed_values.containsKey(ident.toString());
    }

    public CssBackgroundPosition() {
        this.value = new CssBackgroundPositionValue();
    }

    public CssBackgroundPosition(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssValueList b_val = null;
        ArrayList<CssValueList> values = new ArrayList<CssValueList>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            if (b_val == null) {
                b_val = new CssBackgroundPositionValue();
            }
            b_val.add(val);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                this.check((CssBackgroundPositionValue)b_val, ac);
                values.add(b_val);
                b_val = null;
                continue;
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (b_val != null) {
            this.check((CssBackgroundPositionValue)b_val, ac);
            values.add(b_val);
        }
        this.value = values.size() == 1 ? values.get(0) : values;
    }

    public CssBackgroundPosition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public void set(Object val) {
        this.value = val;
    }

    public final String getPropertyName() {
        return propertyName;
    }

    public boolean isSoftlyInherited() {
        return inherit == this.value;
    }

    public String toString() {
        if (this.value instanceof ArrayList) {
            ArrayList v_list = (ArrayList)this.value;
            StringBuilder sb = new StringBuilder();
            for (Object val : v_list) {
                sb.append(val.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }
        return this.value.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackground cssBackground = ((Css1Style)style).cssBackground;
        if (cssBackground.position != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.position = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundPosition();
        }
        return ((Css1Style)style).cssBackground.position;
    }

    public boolean equals(CssProperty property) {
        return property != null && property instanceof CssBackgroundPosition && this.value.equals(((CssBackgroundPosition)property).value);
    }

    public boolean isDefault() {
        if (!(this.value instanceof CssBackgroundPositionValue)) {
            return false;
        }
        CssBackgroundPositionValue v = (CssBackgroundPositionValue)this.value;
        return v.val_vertical == defaultPercent0 && v.val_horizontal == defaultPercent0 && v.vertical_offset == null && v.horizontal_offset == null;
    }

    public void check(CssBackgroundPositionValue v, ApplContext ac) throws InvalidParamException {
        int nb_keyword = 0;
        int nb_percentage = 0;
        int nb_length = 0;
        int nb_values = v.value.size();
        if (nb_values > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        block23: for (CssValue aValue : v.value) {
            switch (aValue.getType()) {
                case 5: {
                    aValue = ((CssNumber)aValue).getLength();
                }
                case 6: {
                    ++nb_length;
                    continue block23;
                }
                case 4: {
                    ++nb_percentage;
                    continue block23;
                }
                case 0: {
                    ++nb_keyword;
                    continue block23;
                }
            }
            throw new InvalidParamException("unrecognize", aValue, ac);
        }
        if (nb_keyword > 2 || nb_length > 2 || nb_percentage > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        block6 : switch (nb_keyword) {
            case 0: {
                switch (nb_values) {
                    case 1: {
                        v.horizontal = (CssValue)v.value.get(0);
                        if (v.horizontal.getType() == 5) {
                            v.horizontal = defaultPercent0;
                        }
                        v.val_horizontal = v.horizontal;
                        v.val_vertical = defaultPercent50;
                        break block6;
                    }
                    case 2: {
                        v.horizontal = (CssValue)v.value.get(0);
                        if (v.horizontal.getType() == 5) {
                            v.horizontal = defaultPercent0;
                        }
                        v.val_horizontal = v.horizontal;
                        v.vertical = (CssValue)v.value.get(1);
                        if (v.vertical.getType() == 5) {
                            v.vertical = defaultPercent0;
                        }
                        v.val_vertical = v.vertical;
                        break block6;
                    }
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            case 1: {
                switch (nb_values) {
                    case 1: {
                        CssIdent ident = (CssIdent)v.value.get(0);
                        v.val_vertical = defaultPercent50;
                        v.val_horizontal = defaultPercent50;
                        ident = allowed_values.get(ident.toString());
                        if (ident != null) {
                            if (CssBackgroundPosition.isVertical(ident)) {
                                v.vertical = ident;
                                v.val_vertical = CssBackgroundPosition.identToPercent(ident);
                                break block6;
                            }
                            v.horizontal = ident;
                            v.val_horizontal = CssBackgroundPosition.identToPercent(ident);
                            break block6;
                        }
                        throw new InvalidParamException("unrecognize", ident, propertyName, ac);
                    }
                    case 2: {
                        CssIdent ident;
                        CssValue val0 = (CssValue)v.value.get(0);
                        if (val0.getType() == 0) {
                            ident = allowed_values.get(val0.toString());
                            if (ident == null) {
                                throw new InvalidParamException("unrecognize", ident, propertyName, ac);
                            }
                            if (CssBackgroundPosition.isVertical(ident)) {
                                throw new InvalidParamException("incompatible", ident, v.value.get(1), ac);
                            }
                            v.horizontal = ident;
                            v.val_horizontal = CssBackgroundPosition.identToPercent(ident);
                            v.vertical = (CssValue)v.value.get(1);
                            if (v.vertical.getType() == 5) {
                                v.vertical = defaultPercent0;
                            }
                            v.val_vertical = v.vertical;
                            break block6;
                        }
                        ident = allowed_values.get(((CssValue)v.value.get(1)).toString());
                        if (ident == null) {
                            throw new InvalidParamException("unrecognize", ident, propertyName, ac);
                        }
                        if (CssBackgroundPosition.isHorizontal(ident)) {
                            throw new InvalidParamException("incompatible", val0, v.value.get(1), ac);
                        }
                        v.vertical = ident;
                        v.val_vertical = CssBackgroundPosition.identToPercent(ident);
                        v.horizontal = val0;
                        if (v.horizontal.getType() == 5) {
                            v.horizontal = defaultPercent0;
                        }
                        v.val_horizontal = v.horizontal;
                        break block6;
                    }
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            default: {
                boolean got_ident = false;
                CssIdent id1 = null;
                CssIdent id2 = null;
                CssValue off1 = null;
                CssValue off2 = null;
                for (CssValue aValue : v.value) {
                    switch (aValue.getType()) {
                        case 0: {
                            aValue = allowed_values.get(aValue.toString());
                            if (aValue == null) {
                                throw new InvalidParamException("unrecognize", aValue, propertyName, ac);
                            }
                            got_ident = true;
                            if (id1 == null) {
                                id1 = (CssIdent)aValue;
                                break;
                            }
                            id2 = (CssIdent)aValue;
                            if ((!CssBackgroundPosition.isVertical(id1) || !CssBackgroundPosition.isVertical(id2)) && (!CssBackgroundPosition.isHorizontal(id1) || !CssBackgroundPosition.isHorizontal(id2))) break;
                            throw new InvalidParamException("incompatible", id1, id2, ac);
                        }
                        case 5: {
                            aValue = ((CssNumber)aValue).getPercentage();
                        }
                        case 4: 
                        case 6: {
                            if (!got_ident) {
                                throw new InvalidParamException("unrecognize", aValue, propertyName, ac);
                            }
                            if (id2 == null) {
                                off1 = aValue;
                            } else {
                                off2 = aValue;
                            }
                            got_ident = false;
                            break;
                        }
                    }
                }
                if (CssBackgroundPosition.isVertical(id1) || CssBackgroundPosition.isHorizontal(id2)) {
                    if (off1 != null && !CssBackgroundPosition.isVertical(id1) || off2 != null && !CssBackgroundPosition.isHorizontal(id2)) {
                        throw new InvalidParamException("incompatible", id1, id2, ac);
                    }
                    v.horizontal = id2;
                    v.val_horizontal = CssBackgroundPosition.identToPercent(id2);
                    v.horizontal_offset = off2;
                    v.vertical = id1;
                    v.val_vertical = CssBackgroundPosition.identToPercent(id1);
                    v.vertical_offset = off1;
                    break;
                }
                if (off2 != null && !CssBackgroundPosition.isVertical(id2) || off1 != null && !CssBackgroundPosition.isHorizontal(id1)) {
                    throw new InvalidParamException("incompatible", id1, id2, ac);
                }
                v.horizontal = id1;
                v.val_horizontal = CssBackgroundPosition.identToPercent(id1);
                v.horizontal_offset = off1;
                v.vertical = id2;
                v.val_vertical = CssBackgroundPosition.identToPercent(id2);
                v.vertical_offset = off2;
            }
        }
    }

    public static CssPercentage identToPercent(CssIdent ident) {
        if (center.equals(ident)) {
            return defaultPercent50;
        }
        if (top.equals(ident) || left.equals(ident)) {
            return defaultPercent0;
        }
        if (bottom.equals(ident) || right.equals(ident)) {
            return defaultPercent100;
        }
        return defaultPercent0;
    }

    public static boolean isHorizontal(CssIdent ident) {
        return left.equals(ident) || right.equals(ident);
    }

    public static boolean isVertical(CssIdent ident) {
        return top.equals(ident) || bottom.equals(ident);
    }

    static /* synthetic */ CssPercentage access$000() {
        return defaultPercent0;
    }

    static {
        top = CssIdent.getIdent("top");
        bottom = CssIdent.getIdent("bottom");
        left = CssIdent.getIdent("left");
        right = CssIdent.getIdent("right");
        center = CssIdent.getIdent("center");
        allowed_values = new HashMap();
        allowed_values.put("top", top);
        allowed_values.put("bottom", bottom);
        allowed_values.put("left", left);
        allowed_values.put("right", right);
        allowed_values.put("center", center);
        defaultPercent0 = new CssPercentage(0);
        defaultPercent50 = new CssPercentage(50);
        defaultPercent100 = new CssPercentage(100);
    }

    public class CssBackgroundPositionValue
    extends CssValueList {
        public CssValue vertical = null;
        public CssValue horizontal = null;
        public CssValue vertical_offset = null;
        public CssValue horizontal_offset = null;
        public CssValue val_vertical = CssBackgroundPosition.access$000();
        public CssValue val_horizontal = CssBackgroundPosition.access$000();

        public boolean equals(CssBackgroundPositionValue v) {
            if (!this.val_vertical.equals(v.val_vertical)) {
                return false;
            }
            if (this.vertical_offset != null ? !this.vertical_offset.equals(v.vertical_offset) : v.vertical_offset != null) {
                return false;
            }
            if (!this.val_horizontal.equals(v.val_horizontal)) {
                return false;
            }
            return !(this.horizontal_offset != null ? !this.horizontal_offset.equals(v.horizontal_offset) : v.horizontal_offset != null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.horizontal != null) {
                sb.append(this.horizontal);
                if (this.horizontal_offset != null) {
                    sb.append(' ').append(this.horizontal_offset);
                }
                if (this.vertical != null) {
                    sb.append(' ');
                }
            }
            if (this.vertical != null) {
                sb.append(this.vertical);
                if (this.vertical_offset != null) {
                    sb.append(' ').append(this.vertical_offset);
                }
            }
            return sb.toString();
        }
    }
}

