/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssBackground;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssColor;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public class CssBackgroundColor
extends CssProperty {
    CssValue color;
    private static final String propertyName = "background-color";

    public CssBackgroundColor() {
        this.color = transparent;
    }

    public CssBackgroundColor(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (inherit.equals(val)) {
            this.color = inherit;
            expression.next();
        } else {
            try {
                CssColor tcolor = new CssColor(ac, expression, check2);
                this.color = tcolor.getColor();
            }
            catch (InvalidParamException e) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
        }
    }

    public CssBackgroundColor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.color;
    }

    public void set(CssValue col) {
        this.color = col;
    }

    public CssValue getColor() {
        return this.color;
    }

    public boolean isSoftlyInherited() {
        return this.color.equals(inherit);
    }

    public String toString() {
        return this.color.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackground cssBackground = ((Css1Style)style).cssBackground;
        if (cssBackground.color != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.color = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundColor();
        }
        return ((Css1Style)style).cssBackground.color;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundColor && this.color.equals(((CssBackgroundColor)property).color);
    }

    public final String getPropertyName() {
        return propertyName;
    }

    public boolean isDefault() {
        return this.color == transparent;
    }
}

