/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.aural;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.aural.ACssProperties;
import org.w3c.css.properties.aural.ACssProperty;
import org.w3c.css.properties.aural.ACssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssDate;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;

public class ACssInterpretAs
extends ACssProperty {
    CssValue value;
    private static CssTime defaultValue;
    private static String[] interpretas;

    public ACssInterpretAs() {
        if (defaultValue == null) {
            defaultValue = new CssTime(ACssProperties.getValue(this, "default"));
        }
        this.value = defaultValue;
    }

    public ACssInterpretAs(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val.equals(inherit)) {
            this.value = inherit;
            expression.next();
            return;
        }
        if (val instanceof CssTime) {
            float num = ((Float)val.get()).floatValue();
            if (num < 0.0f) {
                throw new InvalidParamException("negative-value", val.toString(), ac);
            }
            this.value = val;
            expression.next();
            return;
        }
        if (val instanceof CssDate) {
            this.value = val;
            expression.next();
            return;
        }
        if (val instanceof CssIdent) {
            for (int i = 0; i < interpretas.length; ++i) {
                if (!val.toString().equals(interpretas[i])) continue;
                this.value = val;
                expression.next();
                return;
            }
        }
        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
    }

    public ACssInterpretAs(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public int getValue() {
        return ((Float)this.value.get()).intValue();
    }

    public boolean isSoftlyInherited() {
        return this.value == inherit;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public String getPropertyName() {
        return "interpret-as";
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((ACssStyle)style).acssInterpretAs != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((ACssStyle)style).acssInterpretAs = this;
    }

    public boolean equals(CssProperty property) {
        if (this.value != null) {
            return property instanceof ACssInterpretAs && this.value.equals(((ACssInterpretAs)property).value);
        }
        return false;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ACssStyle)style).getInterpretAs();
        }
        return ((ACssStyle)style).acssInterpretAs;
    }

    static {
        interpretas = new String[]{"currency", "measure", "telephone", "address", "name", "net"};
    }
}

