/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.atsc;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.atsc.ATSCStyle;
import org.w3c.css.properties.atsc.CssBackgroundATSC;
import org.w3c.css.properties.css.CssBackgroundConstants;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssBackgroundPositionATSC
extends CssProperty
implements CssBackgroundConstants,
CssOperator {
    CssValue first;
    CssValue second;
    private static int[] hash_values;
    private static CssPercentage DefaultValue0;

    public CssBackgroundPositionATSC() {
        this.first = DefaultValue0;
        this.second = DefaultValue0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CssBackgroundPositionATSC(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (op != ' ') {
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (val.equals(inherit)) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.first = inherit;
            this.second = inherit;
            expression.next();
            return;
        }
        CssValue next = expression.getNextValue();
        if (val instanceof CssIdent) {
            int index1 = this.IndexOfIdent((String)val.get());
            if (next instanceof CssIdent) {
                int index2 = this.IndexOfIdent((String)next.get());
                if (this.isHorizontal(index1) && this.isVertical(index2) || this.isHorizontal(index2) && this.isVertical(index1)) {
                    this.first = val;
                    this.second = next;
                } else {
                    if (check2) {
                        throw new InvalidParamException("incompatible", val, next, ac);
                    }
                    this.first = val;
                }
            } else if (next instanceof CssLength || next instanceof CssPercentage || next instanceof CssNumber) {
                if (next instanceof CssNumber) {
                    next = ((CssNumber)next).getLength();
                }
                if (!this.isHorizontal(index1)) throw new InvalidParamException("incompatible", val, next, ac);
                this.first = val;
                this.second = next;
            } else if (next == null) {
                this.first = val;
            } else {
                if (check2) {
                    throw new InvalidParamException("value", next, this.getPropertyName(), ac);
                }
                this.first = val;
            }
        } else if (val instanceof CssLength || val instanceof CssPercentage || val instanceof CssNumber) {
            if (val instanceof CssNumber) {
                val = ((CssNumber)val).getLength();
            }
            if (next instanceof CssIdent) {
                int index = this.IndexOfIdent((String)next.get());
                if (this.isVertical(index)) {
                    this.first = val;
                    this.second = next;
                } else {
                    if (check2) {
                        throw new InvalidParamException("incompatible", val, next, ac);
                    }
                    this.first = val;
                }
            } else if (next instanceof CssLength || next instanceof CssPercentage || next instanceof CssNumber) {
                if (next instanceof CssNumber) {
                    next = ((CssNumber)next).getLength();
                }
                this.first = val;
                this.second = next;
            } else {
                if (next != null && check2) throw new InvalidParamException("incompatible", val, next, ac);
                this.first = val;
            }
        } else if (check2) {
            throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
        }
        if (this.first != null) {
            expression.next();
        }
        if (this.second == null) return;
        expression.next();
    }

    public CssBackgroundPositionATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private boolean isHorizontal(int index) {
        return index == 3 || index == 4 || index == 1;
    }

    private boolean isVertical(int index) {
        return index == 0 || index == 2 || index == 1;
    }

    public Object get() {
        return this.first;
    }

    public String getPropertyName() {
        return "background-position";
    }

    public CssValue getHorizontalPosition() {
        return this.first;
    }

    public CssValue getVerticalPosition() {
        return this.second;
    }

    public boolean isSoftlyInherited() {
        return this.first == inherit;
    }

    public String toString() {
        if (this.first == inherit) {
            return inherit.toString();
        }
        String ret = "";
        if (this.first != null) {
            ret = ret + this.first;
        }
        if (this.second != null) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + this.second;
        }
        return ret;
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackgroundATSC cssBackground = ((ATSCStyle)style).cssBackgroundATSC;
        if (cssBackground.position != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.position = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ATSCStyle)style).getBackgroundPositionATSC();
        }
        return ((ATSCStyle)style).cssBackgroundATSC.position;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundPositionATSC && this.first.equals(((CssBackgroundPositionATSC)property).first) && this.second.equals(((CssBackgroundPositionATSC)property).second);
    }

    public boolean isDefault() {
        return this.first.equals(DefaultValue0) && this.second.equals(DefaultValue0);
    }

    private int IndexOfIdent(String ident) throws InvalidParamException {
        int hash = ident.hashCode();
        for (int i = 0; i < POSITION.length; ++i) {
            if (hash_values[i] != hash) continue;
            return i;
        }
        return -1;
    }

    static {
        DefaultValue0 = new CssPercentage(0);
        hash_values = new int[POSITION.length];
        for (int i = 0; i < POSITION.length; ++i) {
            CssBackgroundPositionATSC.hash_values[i] = POSITION[i].hashCode();
        }
    }
}

