/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleMedia;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssPropertyFactory
implements Cloneable {
    private Utf8Properties properties;
    private static String[] SORTEDPROFILES = PropertiesLoader.getProfiles();

    public CssPropertyFactory getClone() {
        try {
            return (CssPropertyFactory)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public CssPropertyFactory(String profile) {
        this.properties = PropertiesLoader.getProfile(profile);
        if (this.properties == null) {
            throw new NullPointerException();
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private Vector<String> getVector(String media) {
        Vector<String> list = new Vector<String>(4);
        String medium = new String();
        StringTokenizer tok = new StringTokenizer(media, ",");
        while (tok.hasMoreTokens()) {
            medium = tok.nextToken();
            medium = medium.trim();
            list.addElement(medium);
        }
        return list;
    }

    public synchronized CssProperty createMediaFeature(ApplContext ac, AtRule atRule, String property, CssExpression expression) throws Exception {
        String media = atRule.toString();
        int pos = -1;
        int pos2 = media.toUpperCase().indexOf("AND");
        if (pos2 == -1) {
            pos2 = media.length();
        }
        if (media.toUpperCase().indexOf("NOT") != -1) {
            pos = media.toUpperCase().indexOf("NOT");
            media = media.substring(pos + 4, pos2);
        } else if (media.toUpperCase().indexOf("ONLY") != -1) {
            pos = media.toUpperCase().indexOf("ONLY");
            media = media.substring(pos + 4, pos2);
        } else {
            pos = media.indexOf(" ");
            media = media.substring(pos + 1, pos2);
        }
        media = media.trim();
        String classname = this.properties.getProperty("mediafeature." + property);
        if (classname == null) {
            if (atRule instanceof AtRuleMedia && !media.equals("all")) {
                throw new InvalidParamException("noexistence-media", property, media, ac);
            }
            throw new InvalidParamException("noexistence", property, media, ac);
        }
        try {
            Class expressionclass = CssExpression.class;
            if (expression != null) {
                expressionclass = expression.getClass();
            }
            Class[] parametersType = new Class[]{ac.getClass(), expressionclass};
            Constructor<?> constructor = Class.forName(classname).getConstructor(parametersType);
            Object[] parameters = new Object[]{ac, expression};
            return (CssProperty)constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            InvocationTargetException iv = e;
            Exception ex = (Exception)iv.getTargetException();
            throw ex;
        }
    }

    public synchronized CssProperty createProperty(ApplContext ac, AtRule atRule, String property, CssExpression expression) throws Exception {
        String classname = null;
        String media = atRule.toString();
        int pos = -1;
        String upperMedia = media.toUpperCase();
        int pos2 = upperMedia.indexOf("AND ");
        if (pos2 == -1) {
            pos2 = media.length();
        }
        if ((pos = upperMedia.indexOf("NOT")) != -1) {
            media = media.substring(pos + 4, pos2);
        } else {
            pos = upperMedia.indexOf("ONLY");
            if (pos != -1) {
                media = media.substring(pos + 4, pos2);
            } else {
                pos = media.indexOf(32);
                media = media.substring(pos + 1, pos2);
            }
        }
        media = media.trim();
        classname = this.setClassName(atRule, media, ac, property);
        if (classname == null) {
            ArrayList<String> pfsOk = new ArrayList<String>();
            for (int i = 0; i < SORTEDPROFILES.length; ++i) {
                String p = String.valueOf(SORTEDPROFILES[i]);
                if (p.equals(ac.getCssVersion()) || !PropertiesLoader.getProfile(p).containsKey(property)) continue;
                pfsOk.add(p);
            }
            if (pfsOk.size() > 0) {
                throw new InvalidParamException("noexistence", new String[]{property, ac.getMsg().getString(ac.getCssVersion()), pfsOk.toString()}, ac);
            }
            throw new InvalidParamException("noexistence-at-all", property, ac);
        }
        CssIdent initial = new CssIdent("initial");
        try {
            if (expression.getValue().equals(initial) && ac.getCssVersion().equals("css3")) {
                Class[] parametersType = new Class[]{};
                Constructor<?> constructor = Class.forName(classname).getConstructor(parametersType);
                Object[] parameters = new Object[]{};
                return (CssProperty)constructor.newInstance(parameters);
            }
            Class[] parametersType = new Class[]{ac.getClass(), expression.getClass(), Boolean.TYPE};
            Constructor<?> constructor = Class.forName(classname).getConstructor(parametersType);
            Object[] parameters = new Object[]{ac, expression, Boolean.TRUE};
            return (CssProperty)constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            InvocationTargetException iv = e;
            Exception ex = (Exception)iv.getTargetException();
            throw ex;
        }
    }

    private String setClassName(AtRule atRule, String media, ApplContext ac, String property) {
        String className;
        Vector<String> list = new Vector<String>(this.getVector(media));
        if (atRule instanceof AtRuleMedia) {
            className = PropertiesLoader.getProfile(ac.getCssVersion()).getProperty(property);
            if (className != null && !media.equals("all")) {
                String propMedia = PropertiesLoader.mediaProperties.getProperty(property);
                for (int i = 0; i < list.size(); ++i) {
                    String medium = list.elementAt(i);
                    if (propMedia.indexOf(medium.toLowerCase()) != -1 || propMedia.equals("all")) continue;
                    ac.getFrame().addWarning("noexistence-media", new String[]{property, medium + " (" + propMedia + ")"});
                }
            }
        } else {
            className = PropertiesLoader.getProfile(ac.getCssVersion()).getProperty("@" + atRule.keyword() + "." + property);
        }
        return className;
    }
}

