/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client.internal;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.vx68k.bitbucket.api.client.TokenRefreshEvent;
import org.vx68k.bitbucket.api.client.TokenRefreshListener;
import org.vx68k.bitbucket.api.client.internal.BasicAuthenticator;
import org.vx68k.bitbucket.api.client.internal.JsonMessageBodyReader;

public final class OAuth2Authenticator
implements ClientRequestFilter {
    private static final Duration EXPIRY_MARGIN = Duration.ofSeconds(60L);
    private final URI baseUri;
    private final URI tokenEndpointUri;
    private final BasicAuthenticator clientAuthenticator;
    private final Set<TokenRefreshListener> tokenRefreshListeners;
    private String accessToken = null;
    private String refreshToken = null;
    private Instant accessTokenExpiry = null;
    private Instant accessTokenExpiryForTest = Instant.MAX;

    public OAuth2Authenticator(URI baseUri, URI tokenEndpointUri) {
        this.baseUri = baseUri;
        this.tokenEndpointUri = tokenEndpointUri;
        this.clientAuthenticator = new BasicAuthenticator();
        this.tokenRefreshListeners = new LinkedHashSet<TokenRefreshListener>();
        if (baseUri == null) {
            throw new IllegalArgumentException("Base URI must not be null");
        }
        if (!baseUri.isAbsolute()) {
            throw new IllegalArgumentException("Base URI must be absolute");
        }
        if (tokenEndpointUri == null) {
            throw new IllegalArgumentException("Token endpoint URI must not be null");
        }
        if (!tokenEndpointUri.isAbsolute()) {
            throw new IllegalArgumentException("Token endpoint URI must be absolute");
        }
    }

    public String getClientId() {
        return this.clientAuthenticator.getUsername();
    }

    public void setClientId(String newValue) {
        this.clientAuthenticator.setUsername(newValue);
    }

    public void setClientSecret(String newValue) {
        this.clientAuthenticator.setPassword(newValue);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String newValue) {
        this.accessToken = newValue;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String newValue) {
        this.refreshToken = newValue;
    }

    public Instant getAccessTokenExpiry() {
        return this.accessTokenExpiry;
    }

    public void setAccessTokenExpiry(Instant newValue) {
        this.accessTokenExpiry = newValue;
        this.accessTokenExpiryForTest = Instant.MAX;
        if (this.accessTokenExpiry != null) {
            this.accessTokenExpiryForTest = this.accessTokenExpiry.minus(EXPIRY_MARGIN);
        }
    }

    protected void fireTokenRefreshed() {
        this.fireTokenRefreshed(new TokenRefreshEvent(this));
    }

    protected void fireTokenRefreshed(TokenRefreshEvent event) {
        this.tokenRefreshListeners.forEach(l -> l.tokenRefreshed(event));
    }

    public void addTokenRefreshListener(TokenRefreshListener listener) {
        this.tokenRefreshListeners.add(listener);
    }

    public void removeTokenRefreshListener(TokenRefreshListener listener) {
        this.tokenRefreshListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAccessToken(Entity formEntity) {
        try (Client client = ClientBuilder.newClient();){
            client.register(JsonMessageBodyReader.class);
            client.register((Object)this.clientAuthenticator);
            JsonObject object = (JsonObject)client.target(this.tokenEndpointUri).request(new String[]{"application/json"}).post(formEntity, JsonObject.class);
            this.setAccessToken(object.getString("access_token"));
            this.setRefreshToken(object.getString("refresh_token", null));
            Instant expiry = null;
            if (object.containsKey((Object)"expires_in")) {
                expiry = Instant.now().plusSeconds(object.getInt("expires_in"));
            }
            this.setAccessTokenExpiry(expiry);
        }
    }

    protected void refreshAccessToken() {
        if (this.refreshToken != null) {
            Form form = new Form("grant_type", "refresh_token");
            form.param("refresh_token", this.refreshToken);
            this.requestAccessToken(Entity.form((Form)form));
            this.fireTokenRefreshed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ClientRequestContext requestContext) {
        MultivaluedMap headers = requestContext.getHeaders();
        URI uri = requestContext.getUri();
        if (this.accessToken != null && !uri.equals(this.baseUri.relativize(uri))) {
            OAuth2Authenticator oAuth2Authenticator = this;
            synchronized (oAuth2Authenticator) {
                if (this.accessTokenExpiryForTest.isBefore(Instant.now())) {
                    this.refreshAccessToken();
                }
            }
            headers.add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
    }
}

