/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.function.Function;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.vx68k.bitbucket.api.client.BitbucketClient;

public class PaginatedList<E>
extends AbstractList<E> {
    private final BitbucketClient bitbucketClient;
    private final Function<JsonObject, ? extends E> creator;
    private URI nextPage;
    private final ArrayList<E> knownValues = new ArrayList();
    private int knownSize = -1;

    public PaginatedList(URI firstPage, BitbucketClient bitbucketClient, Function<JsonObject, ? extends E> creator) {
        this.bitbucketClient = bitbucketClient;
        this.creator = creator;
        this.nextPage = firstPage;
    }

    protected final void fetchNext() {
        JsonObject object = this.bitbucketClient.get(this.nextPage);
        if (this.knownSize < 0) {
            this.knownSize = object.getInt("size", -1);
            if (this.knownSize >= 0) {
                this.knownValues.ensureCapacity(this.knownSize);
            }
        }
        JsonArray values = object.getJsonArray("values");
        values.stream().map(value -> (JsonObject)value).map(this.creator).forEachOrdered(e -> this.knownValues.add(e));
        String next = object.getString("next", null);
        if (next != null) {
            this.nextPage = URI.create(next);
        } else {
            this.nextPage = null;
            this.knownSize = this.knownValues.size();
        }
    }

    @Override
    public final E get(int index) {
        while (this.nextPage != null && index >= this.knownValues.size()) {
            this.fetchNext();
        }
        return this.knownValues.get(index);
    }

    @Override
    public final int size() {
        while (this.nextPage != null && this.knownSize < 0) {
            this.fetchNext();
        }
        assert (this.knownSize >= 0);
        return this.knownSize;
    }
}

