/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.util.Objects;
import javax.json.JsonObject;
import javax.ws.rs.core.Link;
import org.vx68k.bitbucket.api.client.BitbucketClient;
import org.vx68k.bitbucket.api.client.JsonUtilities;

public class BitbucketClientObject {
    static final String TYPE = "type";
    private static final String LINKS = "links";
    private final JsonObject jsonObject;
    private BitbucketClient bitbucketClient;

    public BitbucketClientObject(JsonObject jsonObject) {
        this(jsonObject, null);
    }

    public BitbucketClientObject(JsonObject jsonObject, BitbucketClient bitbucketClient) {
        this.jsonObject = jsonObject;
        this.bitbucketClient = bitbucketClient;
        if (this.jsonObject == null) {
            throw new IllegalArgumentException("JSON object is null");
        }
    }

    public final JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public final BitbucketClient getBitbucketClient() {
        return this.bitbucketClient;
    }

    public final void setBitbucketClient(BitbucketClient value) {
        this.bitbucketClient = value;
    }

    public final String getType() {
        JsonObject object = this.getJsonObject();
        return object.getString(TYPE, null);
    }

    public final Link getLink(String name) {
        Link value = null;
        JsonObject links = this.getJsonObject().getJsonObject(LINKS);
        if (links != null) {
            value = JsonUtilities.toLink(links.getJsonObject(name));
        }
        return value;
    }

    public int hashCode() {
        int k = 257;
        int value = this.getClass().hashCode();
        value = 257 * value + Objects.hashCode(this.jsonObject);
        return value;
    }

    public boolean equals(Object object) {
        if (this != object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            BitbucketClientObject other = (BitbucketClientObject)object;
            if (!Objects.equals(this.jsonObject, other.jsonObject)) {
                return false;
            }
            if (!Objects.equals(this.bitbucketClient, other.bitbucketClient)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.jsonObject.toString();
    }
}

