/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.fragments.tpf;

import javax.servlet.http.HttpServletRequest;
import org.linkeddatafragments.config.ConfigReader;
import org.linkeddatafragments.fragments.FragmentRequestParserBase;
import org.linkeddatafragments.fragments.ILinkedDataFragmentRequest;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.TriplePatternFragmentRequestImpl;
import org.linkeddatafragments.util.TriplePatternElementParser;

public class TPFRequestParser<ConstantTermType, NamedVarType, AnonVarType>
extends FragmentRequestParserBase {
    public final TriplePatternElementParser<ConstantTermType, NamedVarType, AnonVarType> elmtParser;

    public TPFRequestParser(TriplePatternElementParser<ConstantTermType, NamedVarType, AnonVarType> elmtParser) {
        this.elmtParser = elmtParser;
    }

    @Override
    protected Worker getWorker(HttpServletRequest httpRequest, ConfigReader config) throws IllegalArgumentException {
        return new Worker(httpRequest, config);
    }

    protected class Worker
    extends FragmentRequestParserBase.Worker {
        public Worker(HttpServletRequest request, ConfigReader config) {
            super(request, config);
        }

        @Override
        public ILinkedDataFragmentRequest createFragmentRequest() throws IllegalArgumentException {
            return new TriplePatternFragmentRequestImpl(this.getFragmentURL(), this.getDatasetURL(), this.pageNumberWasRequested, this.pageNumber, this.getSubject(), this.getPredicate(), this.getObject());
        }

        public ITriplePatternElement<ConstantTermType, NamedVarType, AnonVarType> getSubject() {
            return this.getParameterAsTriplePatternElement("subject");
        }

        public ITriplePatternElement<ConstantTermType, NamedVarType, AnonVarType> getPredicate() {
            return this.getParameterAsTriplePatternElement("predicate");
        }

        public ITriplePatternElement<ConstantTermType, NamedVarType, AnonVarType> getObject() {
            return this.getParameterAsTriplePatternElement("object");
        }

        public ITriplePatternElement<ConstantTermType, NamedVarType, AnonVarType> getParameterAsTriplePatternElement(String paramName) {
            String parameter = this.request.getParameter(paramName);
            return TPFRequestParser.this.elmtParser.parseIntoTriplePatternElement(parameter);
        }
    }
}

