/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.fragments;

import javax.servlet.http.HttpServletRequest;
import org.linkeddatafragments.config.ConfigReader;
import org.linkeddatafragments.fragments.IFragmentRequestParser;
import org.linkeddatafragments.fragments.ILinkedDataFragmentRequest;

public abstract class FragmentRequestParserBase
implements IFragmentRequestParser {
    @Override
    public final ILinkedDataFragmentRequest parseIntoFragmentRequest(HttpServletRequest httpRequest, ConfigReader config) throws IllegalArgumentException {
        return this.getWorker(httpRequest, config).createFragmentRequest();
    }

    protected abstract Worker getWorker(HttpServletRequest var1, ConfigReader var2) throws IllegalArgumentException;

    public static String extractBaseURL(HttpServletRequest request, ConfigReader config) {
        if (config.getBaseURL() != null) {
            return config.getBaseURL();
        }
        if (request.getServerPort() == 80 || request.getServerPort() == 443) {
            return request.getScheme() + "://" + request.getServerName();
        }
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    }

    protected static abstract class Worker {
        public final HttpServletRequest request;
        public final ConfigReader config;
        public final boolean pageNumberWasRequested;
        public final long pageNumber;

        public Worker(HttpServletRequest request, ConfigReader config) {
            this.request = request;
            this.config = config;
            String givenPageNumber = request.getParameter("page");
            if (givenPageNumber != null) {
                long pageNumber;
                try {
                    pageNumber = Long.parseLong(givenPageNumber);
                }
                catch (NumberFormatException ex) {
                    pageNumber = 1L;
                }
                this.pageNumber = pageNumber > 0L ? pageNumber : 1L;
                this.pageNumberWasRequested = true;
            } else {
                this.pageNumber = 1L;
                this.pageNumberWasRequested = false;
            }
        }

        public abstract ILinkedDataFragmentRequest createFragmentRequest() throws IllegalArgumentException;

        public String getFragmentURL() {
            String datasetURL = this.getDatasetURL();
            String query = this.request.getQueryString();
            return query == null ? datasetURL : datasetURL + "?" + query;
        }

        public String getDatasetURL() {
            return FragmentRequestParserBase.extractBaseURL(this.request, this.config) + this.request.getRequestURI();
        }
    }
}

