/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.linkeddatafragments.datasource.IDataSourceType;

public class ConfigReader {
    private final Map<String, IDataSourceType> dataSourceTypes = new HashMap<String, IDataSourceType>();
    private final Map<String, JsonNode> dataSources = new HashMap<String, JsonNode>();
    private final Map<String, String> prefixes = new HashMap<String, String>();
    private final String baseURL;

    public ConfigReader(Reader configReader) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = null;
        try {
            Map.Entry entry;
            root = mapper.readTree(configReader);
            this.baseURL = root.has("baseURL") ? root.get("baseURL").asText() : null;
            Iterator iterator = root.get("datasourcetypes").fields();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                String className = ((JsonNode)entry.getValue()).asText();
                this.dataSourceTypes.put((String)entry.getKey(), this.initDataSouceType(className));
            }
            iterator = root.get("datasources").fields();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                this.dataSources.put((String)entry.getKey(), (JsonNode)entry.getValue());
            }
            iterator = root.get("prefixes").fields();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                this.prefixes.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, IDataSourceType> getDataSourceTypes() {
        return this.dataSourceTypes;
    }

    public Map<String, JsonNode> getDataSources() {
        return this.dataSources;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    protected IDataSourceType initDataSouceType(String className) {
        Object o;
        Class<?> c;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
        try {
            o = c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Creating an instance of class '" + className + "' caused a " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        if (!(o instanceof IDataSourceType)) {
            throw new IllegalArgumentException("Class '" + className + "' is not an implementation of IDataSourceType.");
        }
        return (IDataSourceType)o;
    }
}

