/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.vitro.opensocial;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContextImpl;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalyzer;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestInfo;
import edu.ucsf.vitro.opensocial.GadgetSpec;
import edu.ucsf.vitro.opensocial.PreparedGadget;
import java.io.IOException;
import java.net.Socket;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenSocialManager {
    public static final String SHINDIG_URL_PROP = "OpenSocial.shindigURL";
    public static final String OPENSOCIAL_DEBUG = "OPENSOCIAL_DEBUG";
    public static final String OPENSOCIAL_NOCACHE = "OPENSOCIAL_NOCACHE";
    public static final String OPENSOCIAL_GADGETS = "OPENSOCIAL_GADGETS";
    public static final String JSON_PERSONID_CHANNEL = "JSONPersonIds";
    public static final String JSON_PMID_CHANNEL = "JSONPubMedIds";
    public static final String TAG_NAME = "openSocial";
    private static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private static final Log log = LogFactory.getLog(OpenSocialManager.class);
    private static Map<String, GadgetSpec> gadgetCache;
    private List<PreparedGadget> gadgets = new ArrayList<PreparedGadget>();
    private Map<String, String> pubsubdata = new HashMap<String, String>();
    private String viewerId = null;
    private String ownerId = null;
    private boolean isDebug = false;
    private boolean noCache = false;
    private String pageName;
    private ConfigurationProperties configuration;
    private BasicDataSource dataSource;

    public OpenSocialManager(VitroRequest vreq, String pageName) throws SQLException, IOException {
        this(vreq, pageName, false);
    }

    public OpenSocialManager(VitroRequest vreq, String pageName, boolean editMode) throws SQLException, IOException {
        this.isDebug = vreq.getSession() != null && Boolean.TRUE.equals(vreq.getSession().getAttribute(OPENSOCIAL_DEBUG));
        this.noCache = vreq.getSession() != null && Boolean.TRUE.equals(vreq.getSession().getAttribute(OPENSOCIAL_NOCACHE));
        this.pageName = pageName;
        this.configuration = ConfigurationProperties.getBean(vreq.getSession().getServletContext());
        if (this.configuration.getProperty(SHINDIG_URL_PROP) == null) {
            return;
        }
        this.ownerId = this.figureOwnerId(vreq);
        if (editMode) {
            this.viewerId = this.ownerId;
        } else {
            UserAccount viewer = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
            Collection<String> profileUris = HasProfile.getProfileUris(RequestIdentifiers.getIdBundleForRequest((ServletRequest)vreq));
            this.viewerId = !profileUris.isEmpty() ? profileUris.iterator().next() : (viewer != null ? viewer.getUri() : null);
        }
        String requestAppId = vreq.getParameter("appId");
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(DEFAULT_DRIVER);
        this.dataSource.setUsername(this.configuration.getProperty("VitroConnection.DataSource.username"));
        this.dataSource.setPassword(this.configuration.getProperty("VitroConnection.DataSource.password"));
        this.dataSource.setUrl(this.configuration.getProperty("VitroConnection.DataSource.url"));
        Map<String, GadgetSpec> allDBGadgets = this.getAllDBGadgets(!this.noCache);
        if (vreq.getSession() != null && vreq.getSession().getAttribute(OPENSOCIAL_GADGETS) != null) {
            this.gadgets = this.getSandboxGadgets(vreq, allDBGadgets, requestAppId);
        } else {
            for (GadgetSpec gadgetSpec : allDBGadgets.values()) {
                int moduleId = 0;
                if ((requestAppId != null || !gadgetSpec.isEnabled()) && (requestAppId == null || gadgetSpec.getAppId() != Integer.parseInt(requestAppId)) || !gadgetSpec.show(this.viewerId, this.ownerId, pageName, this.dataSource)) continue;
                String securityToken = this.socketSendReceive(this.viewerId, this.ownerId, "" + gadgetSpec.getAppId());
                this.gadgets.add(new PreparedGadget(gadgetSpec, this, moduleId++, securityToken));
            }
        }
        Collections.sort(this.gadgets);
    }

    public static void clearCache() {
        gadgetCache = null;
    }

    private String figureOwnerId(VitroRequest vreq) {
        IndividualRequestAnalyzer requestAnalyzer = new IndividualRequestAnalyzer(vreq, new IndividualRequestAnalysisContextImpl(vreq));
        IndividualRequestInfo requestInfo = requestAnalyzer.analyze();
        Individual owner = requestInfo.getIndividual();
        return owner != null ? owner.getURI() : null;
    }

    private String getGadgetFileNameFromURL(String url) {
        String[] urlbits = url.split("/");
        return urlbits[urlbits.length - 1];
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public boolean hasGadgetListeningTo(String channel) {
        for (PreparedGadget gadget : this.getVisibleGadgets()) {
            if (!gadget.getGadgetSpec().listensTo(channel)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getOpenSocialId(List<Individual> individuals) {
        ArrayList<String> personIds = new ArrayList<String>();
        for (Individual ind : individuals) {
            personIds.add(ind.getURI());
        }
        return personIds;
    }

    public static String buildJSONPersonIds(List<String> personIds, String message) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode json = mapper.createObjectNode();
        json.put("message", message);
        ArrayNode persons = mapper.createArrayNode();
        for (String personId : personIds) {
            persons.add(personId);
        }
        json.put("personIds", (JsonNode)persons);
        return json.toString();
    }

    public static String buildJSONPersonIds(String personId, String message) {
        ArrayList<String> personIds = new ArrayList<String>();
        personIds.add(personId);
        return OpenSocialManager.buildJSONPersonIds(personIds, message);
    }

    public static String buildJSONPersonIds(Individual ind, String message) {
        ArrayList<String> personIds = new ArrayList<String>();
        personIds.add(ind.getURI());
        return OpenSocialManager.buildJSONPersonIds(personIds, message);
    }

    public void setPubsubData(String key, String value) {
        if (this.pubsubdata.containsKey(key)) {
            this.pubsubdata.remove(key);
        }
        if (value != null && !value.isEmpty()) {
            this.pubsubdata.put(key, value);
        }
    }

    public Map<String, String> getPubsubData() {
        return this.pubsubdata;
    }

    public void removePubsubGadgetsWithoutData() {
        ArrayList<PreparedGadget> removedGadgets = new ArrayList<PreparedGadget>();
        block0: for (PreparedGadget gadget : this.gadgets) {
            for (String channel : gadget.getGadgetSpec().getChannels()) {
                if (this.pubsubdata.containsKey(channel)) continue;
                removedGadgets.add(gadget);
                continue block0;
            }
        }
        this.gadgets.removeAll(removedGadgets);
    }

    public void removeGadget(String name) {
        PreparedGadget gadgetToRemove = null;
        for (PreparedGadget gadget : this.gadgets) {
            if (!name.equals(gadget.getName())) continue;
            gadgetToRemove = gadget;
            break;
        }
        this.gadgets.remove(gadgetToRemove);
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getIdToUrlMapJavascript() {
        StringBuilder retval = new StringBuilder("var idToUrlMap = {");
        for (PreparedGadget gadget : this.gadgets) {
            retval.append("'remote_iframe_").append(gadget.getAppId()).append("':'").append(gadget.getGadgetURL()).append("', ");
        }
        return retval.substring(0, retval.length() - 2) + "};";
    }

    public boolean isVisible() {
        return this.configuration.getProperty(SHINDIG_URL_PROP) != null && this.getVisibleGadgets().size() > 0 || this.getPageName().equals("/display");
    }

    public List<PreparedGadget> getVisibleGadgets() {
        return this.gadgets;
    }

    public void postActivity(int userId, String title) throws SQLException {
        this.postActivity(userId, title, null, null, null);
    }

    public void postActivity(int userId, String title, String body) throws SQLException {
        this.postActivity(userId, title, body, null, null);
    }

    public void postActivity(int userId, String title, String body, String xtraId1Type, String xtraId1Value) throws SQLException {
        String sqlCommand = "INSERT INTO orng_activity (userId, activity, xtraId1Type, xtraId1Value) VALUES ('" + userId + "','<activity xmlns=\"http://ns.opensocial.org/2008/opensocial\"><postedTime>" + System.currentTimeMillis() + "</postedTime><title>" + title + "</title>" + (body != null ? "<body>" + body + "</body>" : "") + "</activity>','" + xtraId1Type + "','" + xtraId1Value + "');";
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sqlCommand);
        }
    }

    private String socketSendReceive(String viewer, String owner, String gadget) throws IOException {
        String[] tokenService = this.configuration.getProperty("OpenSocial.tokenService").split(":");
        String request = "c=default" + (viewer != null ? "&v=" + URLEncoder.encode(viewer, "UTF-8") : "") + (owner != null ? "&o=" + URLEncoder.encode(owner, "UTF-8") : "") + "&g=" + gadget + "\r\n";
        Socket s = new Socket(tokenService[0], Integer.parseInt(tokenService[1]));
        s.getOutputStream().write(request.getBytes());
        int bytes = 0;
        StringBuilder page = new StringBuilder();
        byte[] bytesReceived = new byte[256];
        while ((bytes = s.getInputStream().read(bytesReceived)) > 0) {
            page.append(new String(bytesReceived, 0, bytes));
        }
        return page.toString();
    }

    public String getContainerJavascriptSrc() {
        return this.configuration.getProperty(SHINDIG_URL_PROP) + "/gadgets/js/core:dynamic-height:osapi:pubsub:rpc:views:rdf:shindig-container.js?c=1" + (this.isDebug ? "&debug=1" : "");
    }

    public String getGadgetJavascript() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder gadgetScriptText = new StringBuilder("var my = {};" + lineSeparator + "my.gadgetSpec = function(appId, name, url, secureToken, view, chrome_id, opt_params, visible_scope) {" + lineSeparator + "this.appId = appId;" + lineSeparator + "this.name = name;" + lineSeparator + "this.url = url;" + lineSeparator + "this.secureToken = secureToken;" + lineSeparator + "this.view = view || 'default';" + lineSeparator + "this.chrome_id = chrome_id;" + lineSeparator + "this.opt_params = opt_params;" + lineSeparator + "this.visible_scope = visible_scope;" + lineSeparator + "};" + lineSeparator + "my.pubsubData = {};" + lineSeparator);
        for (String key : this.getPubsubData().keySet()) {
            gadgetScriptText.append("my.pubsubData['").append(key).append("'] = '").append(this.getPubsubData().get(key)).append("';").append(lineSeparator);
        }
        gadgetScriptText.append("my.openSocialURL = '").append(this.configuration.getProperty(SHINDIG_URL_PROP)).append("';").append(lineSeparator).append("my.debug = ").append(this.isDebug() ? "1" : "0").append(";").append(lineSeparator).append("my.noCache = ").append(this.noCache() ? "1" : "0").append(";").append(lineSeparator).append("my.gadgets = [");
        for (PreparedGadget gadget : this.getVisibleGadgets()) {
            gadgetScriptText.append("new my.gadgetSpec(").append(gadget.getAppId()).append(",'").append(gadget.getName()).append("','").append(gadget.getGadgetURL()).append("','").append(gadget.getSecurityToken()).append("','").append(gadget.getView()).append("','").append(gadget.getChromeId()).append("',").append(gadget.getOptParams()).append(",'").append(gadget.getGadgetSpec().getVisibleScope()).append("'), ");
        }
        gadgetScriptText = new StringBuilder(gadgetScriptText.substring(0, gadgetScriptText.length() - 2) + "];" + lineSeparator);
        return gadgetScriptText.toString();
    }

    Map<String, GadgetSpec> getAllDBGadgets(boolean useCache) throws SQLException {
        Map<String, GadgetSpec> allDBGadgets;
        Map<String, GadgetSpec> map = allDBGadgets = useCache ? gadgetCache : null;
        if (allDBGadgets == null) {
            allDBGadgets = new HashMap<String, GadgetSpec>();
            String sqlCommand = "select appId, name, url, channels, enabled from orng_apps";
            try (Connection conn = this.dataSource.getConnection();
                 Statement stmt = conn.createStatement();
                 ResultSet rset = stmt.executeQuery(sqlCommand);){
                while (rset.next()) {
                    String channelsStr = rset.getString(4);
                    List<String> channels = Arrays.asList(channelsStr != null && channelsStr.length() > 0 ? channelsStr.split(" ") : new String[]{});
                    GadgetSpec spec = new GadgetSpec(rset.getInt(1), rset.getString(2), rset.getString(3), channels, this.dataSource, rset.getBoolean(5), false);
                    String gadgetFileName = this.getGadgetFileNameFromURL(rset.getString(3));
                    allDBGadgets.put(gadgetFileName, spec);
                }
            }
            if (useCache) {
                gadgetCache = allDBGadgets;
            }
        }
        return allDBGadgets;
    }

    private List<PreparedGadget> getSandboxGadgets(VitroRequest vreq, Map<String, GadgetSpec> allDBGadgets, String requestAppId) throws SQLException, IOException {
        String[] urls;
        ArrayList<PreparedGadget> sandboxGadgets = new ArrayList<PreparedGadget>();
        String openSocialGadgetURLS = (String)vreq.getSession().getAttribute(OPENSOCIAL_GADGETS);
        for (String openSocialGadgetURL : urls = openSocialGadgetURLS.split(System.getProperty("line.separator"))) {
            String gadgetFileName;
            if ((openSocialGadgetURL = openSocialGadgetURL.trim()).length() == 0) continue;
            int appId = 0;
            String name = gadgetFileName = this.getGadgetFileNameFromURL(openSocialGadgetURL);
            ArrayList<String> channels = new ArrayList();
            boolean unknownGadget = true;
            if (allDBGadgets.containsKey(gadgetFileName)) {
                appId = allDBGadgets.get(gadgetFileName).getAppId();
                name = allDBGadgets.get(gadgetFileName).getName();
                channels = allDBGadgets.get(gadgetFileName).getChannels();
                unknownGadget = false;
            } else {
                log.warn((Object)("Could not find " + gadgetFileName + " in " + allDBGadgets.keySet()));
                appId = Math.abs(openSocialGadgetURL.hashCode());
            }
            if (requestAppId != null && Integer.parseInt(requestAppId) != appId) continue;
            GadgetSpec gadget = new GadgetSpec(appId, name, openSocialGadgetURL, channels, this.dataSource, true, unknownGadget);
            int moduleId = 0;
            if (!unknownGadget && !gadget.show(this.viewerId, this.ownerId, this.pageName, this.dataSource)) continue;
            String securityToken = this.socketSendReceive(this.viewerId, this.ownerId, "" + gadget.getAppId());
            sandboxGadgets.add(new PreparedGadget(gadget, this, moduleId++, securityToken));
        }
        return sandboxGadgets;
    }
}

