/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassTemplateModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VClassGroupTemplateModel
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog((String)VClassGroupTemplateModel.class.getName());
    private final VClassGroup vClassGroup;
    private List<VClassTemplateModel> classes;

    public VClassGroupTemplateModel(VClassGroup vClassGroup) {
        this.vClassGroup = vClassGroup;
    }

    public int getDisplayRank() {
        return this.vClassGroup.getDisplayRank();
    }

    public String getUri() {
        return this.vClassGroup.getURI();
    }

    public String getNamespace() {
        return this.vClassGroup.getNamespace();
    }

    public String getLocalName() {
        return this.vClassGroup.getLocalName();
    }

    public String getPublicName() {
        return this.vClassGroup.getPublicName();
    }

    public String getDisplayName() {
        String displayName = this.getPublicName();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = this.getLocalName().replaceFirst("vitroClassGroup", "");
        }
        return displayName;
    }

    public List<VClassTemplateModel> getClasses() {
        if (this.classes == null) {
            List<VClass> classList = this.vClassGroup.getVitroClassList();
            this.classes = new ArrayList<VClassTemplateModel>();
            for (VClass vc : classList) {
                this.classes.add(new VClassTemplateModel(vc));
            }
        }
        return this.classes;
    }

    public int getIndividualCount() {
        if (this.vClassGroup.isIndividualCountSet()) {
            return this.vClassGroup.getIndividualCount();
        }
        return 0;
    }

    public boolean isIndividualCountSet() {
        return this.vClassGroup.isIndividualCountSet();
    }
}

