/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tags
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(Tags.class);
    protected final LinkedHashSet<String> tags;

    public Tags() {
        this.tags = new LinkedHashSet();
    }

    public Tags(LinkedHashSet<String> tags) {
        this.tags = tags;
    }

    public TemplateModel wrap() {
        try {
            return new TagsWrapper().wrap(this);
        }
        catch (TemplateModelException e) {
            log.error((Object)"Error creating Tags template model");
            return null;
        }
    }

    public void add(String ... tags) {
        for (String tag : tags) {
            this.add(tag);
        }
    }

    public void add(String tag) {
        TagVersionInfo info = new TagVersionInfo(tag);
        if (info.hasVersion()) {
            this.tags.add(TagVersionInfo.addVersionNumber(tag, info));
        } else {
            this.tags.add(tag);
        }
    }

    public String list() {
        return StringUtils.join(this.tags, (String)"\n");
    }

    protected static class TagVersionInfo {
        private static final Pattern PATTERN_DOUBLE_QUOTES = Pattern.compile("(href|src)\\s*=\\s*\"([^\"]+)\"[\\s|>]");
        private static final int GROUP_INDEX_DOUBLE_QUOTES = 2;
        private static final Pattern PATTERN_SINGLE_QUOTES = Pattern.compile("(href|src)\\s*=\\s*'([^']+)'[\\s|>]");
        private static final int GROUP_INDEX_SINGLE_QUOTES = 2;
        private static final Pattern PATTERN_NO_QUOTES = Pattern.compile("(href|src)\\s*=\\s*([^\"'<=>\\s]+)[\\s|>]");
        private static final int GROUP_INDEX_NO_QUOTES = 2;
        private MatchResult match;
        private long timestamp = 0L;

        public static String addVersionNumber(String rawTag, TagVersionInfo info) {
            String versionString = info.match.style == MatchResult.Style.NO_QUOTES ? "?version&eq;" : "?version=";
            return rawTag.substring(0, info.match.start) + info.match.group + versionString + TagVersionInfo.smushTimeStamp(info) + rawTag.substring(info.match.end);
        }

        private static String smushTimeStamp(TagVersionInfo info) {
            int smushed = (char)(info.timestamp >> 48) ^ (char)(info.timestamp >> 32) ^ (char)(info.timestamp >> 16) ^ (char)info.timestamp;
            return String.format("%04x", smushed);
        }

        public TagVersionInfo(String rawTag) {
            try {
                String realPath;
                String stripped;
                this.match = TagVersionInfo.findUrlValue(rawTag);
                if (this.match != null && !TagVersionInfo.hasQueryString(this.match.group) && (stripped = TagVersionInfo.stripContextPath(this.match.group)) != null && (realPath = TagVersionInfo.locateRealPath(stripped)) != null) {
                    this.timestamp = TagVersionInfo.getLastModified(realPath);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Failed to add version info to tag: " + rawTag), (Throwable)e);
                this.timestamp = 0L;
            }
        }

        public boolean hasVersion() {
            return this.timestamp != 0L;
        }

        private static MatchResult findUrlValue(String rawTag) {
            Matcher mDouble = PATTERN_DOUBLE_QUOTES.matcher(rawTag);
            if (mDouble.find()) {
                return new MatchResult(mDouble, 2, MatchResult.Style.DOUBLE_QUOTES);
            }
            Matcher mSingle = PATTERN_SINGLE_QUOTES.matcher(rawTag);
            if (mSingle.find()) {
                return new MatchResult(mSingle, 2, MatchResult.Style.SINGLE_QUOTES);
            }
            Matcher mNo = PATTERN_NO_QUOTES.matcher(rawTag);
            if (mNo.find()) {
                return new MatchResult(mNo, 2, MatchResult.Style.NO_QUOTES);
            }
            log.debug((Object)(rawTag + " no match"));
            return null;
        }

        private static boolean hasQueryString(String group) {
            if (group.indexOf(63) > -1) {
                log.debug((Object)(group + " has query string already"));
                return true;
            }
            return false;
        }

        private static String stripContextPath(String group) {
            String contextPath = UrlBuilder.getBaseUrl();
            if (contextPath.isEmpty() || group.startsWith(contextPath)) {
                return group.substring(contextPath.length());
            }
            log.debug((Object)(group + " doesn't match context path"));
            return null;
        }

        private static String locateRealPath(String stripped) {
            ServletContext ctx = ApplicationUtils.instance().getServletContext();
            String realPath = ctx.getRealPath(stripped);
            if (realPath == null) {
                log.debug((Object)(stripped + " has no real path"));
            }
            return realPath;
        }

        private static long getLastModified(String realPath) {
            return new File(realPath).lastModified();
        }

        protected static class MatchResult {
            public final String group;
            public final int start;
            public final int end;
            public final Style style;

            public MatchResult(Matcher matcher, int group, Style style) {
                this.group = matcher.group(group);
                this.start = matcher.start(group);
                this.end = matcher.end(group);
                this.style = style;
                log.debug((Object)this);
            }

            public String toString() {
                return "MatchResult[start=" + this.start + ", end=" + this.end + ", group=" + this.group + ", style=" + (Object)((Object)this.style) + "]";
            }

            public static enum Style {
                SINGLE_QUOTES,
                DOUBLE_QUOTES,
                NO_QUOTES;

            }
        }
    }

    public static class TagsWrapper
    extends BeansWrapper {
        public TagsWrapper() {
            super(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            this.setExposureLevel(1);
        }

        protected void finetuneMethodAppearance(Class cls, Method method, BeansWrapper.MethodAppearanceDecision decision) {
            try {
                String methodName = method.getName();
                if (!methodName.equals("add") && !methodName.equals("list")) {
                    decision.setExposeMethodAs(null);
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

