/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewFinder {
    private static final Log log = LogFactory.getLog(ViewFinder.class);
    private ClassView view;

    public ViewFinder(ClassView view) {
        this.view = view;
    }

    public String findClassView(Individual individual, VitroRequest vreq) {
        String templateName = this.view.getDefaultTemplate();
        String customTemplate = this.findCustomTemplateByVClasses(individual, vreq);
        if (customTemplate != null) {
            templateName = customTemplate;
        }
        log.debug((Object)("Using template " + templateName + " for individual " + individual.getName()));
        return templateName;
    }

    private String findCustomTemplateByVClasses(Individual individual, VitroRequest vreq) {
        return null;
    }

    public static enum ClassView {
        DISPLAY("getCustomDisplayView", "view-display-default.ftl"),
        FORM("getCustomEntryForm", "form-default.ftl"),
        SEARCH("getCustomSearchView", "view-search-default.ftl");

        private Method method = null;
        private String defaultTemplate = null;

        private ClassView(String methodName, String defaultTemplate) {
            Class<VClass> vc = VClass.class;
            this.defaultTemplate = defaultTemplate;
            try {
                this.method = vc.getMethod(methodName, new Class[0]);
            }
            catch (SecurityException e) {
                log.error((Object)("Access denied to method " + methodName + " or class " + vc.getName()));
            }
            catch (NoSuchMethodException e) {
                log.error((Object)("Method " + methodName + " not defined for class " + vc.getName()));
            }
        }

        protected Method getMethod() {
            return this.method;
        }

        protected String getDefaultTemplate() {
            return this.defaultTemplate;
        }
    }
}

