/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.StringResultsMapping;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.ResultSet;

class RdfServiceSelectQueryContext
implements SparqlQueryRunner.SelectQueryContext {
    private static final Log log = LogFactory.getLog(RdfServiceSelectQueryContext.class);
    private final RDFService rdfService;
    private final QueryHolder query;

    RdfServiceSelectQueryContext(RDFService rdfService, QueryHolder query) {
        this.rdfService = rdfService;
        this.query = query;
    }

    @Override
    public RdfServiceSelectQueryContext bindVariableToUri(String name, String uri) {
        return new RdfServiceSelectQueryContext(this.rdfService, this.query.bindToUri(name, uri));
    }

    @Override
    public RdfServiceSelectQueryContext bindVariableToPlainLiteral(String name, String value) {
        return new RdfServiceSelectQueryContext(this.rdfService, this.query.bindToPlainLiteral(name, value));
    }

    public String toString() {
        return "RdfServiceSelectQueryContext[query=" + this.query + "]";
    }

    @Override
    public SparqlQueryRunner.ExecutingSelectQueryContext execute() {
        return new RdfServiceExecutingQueryContext(this.rdfService, this.query);
    }

    private static class RdfServiceExecutingQueryContext
    implements SparqlQueryRunner.ExecutingSelectQueryContext {
        private final RDFService rdfService;
        private final QueryHolder query;

        public RdfServiceExecutingQueryContext(RDFService rdfService, QueryHolder query) {
            this.rdfService = rdfService;
            this.query = query;
        }

        @Override
        public StringResultsMapping toStringFields(String ... names) {
            HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(names));
            try {
                ResultSet results = RDFServiceUtils.sparqlSelectQuery(this.query.getQueryString(), this.rdfService);
                return new StringResultsMapping(results, fieldNames);
            }
            catch (Exception e) {
                log.error((Object)("problem while running query '" + this.query.getQueryString() + "'"), (Throwable)e);
                return StringResultsMapping.EMPTY;
            }
        }

        @Override
        public <T> T parse(ResultSetParser<T> parser) {
            String qString = this.query.getQueryString();
            try {
                return parser.parseResults(qString, RDFServiceUtils.sparqlSelectQuery(qString, this.rdfService));
            }
            catch (Exception e) {
                log.error((Object)("problem while running query '" + qString + "'"), (Throwable)e);
                return parser.defaultValue();
            }
        }

        @Override
        public void writeToOutput(OutputStream output) {
            try {
                InputStream resultStream = this.rdfService.sparqlSelectQuery(this.query.getQueryString(), RDFService.ResultFormat.JSON);
                IOUtils.copy((InputStream)resultStream, (OutputStream)output);
            }
            catch (Exception e) {
                log.error((Object)("problem while running query '" + this.query.getQueryString() + "'"), (Throwable)e);
            }
        }
    }
}

