/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.searchengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoCompleteWords {
    private static final Log log = LogFactory.getLog(AutoCompleteWords.class);
    private final String searchTerm;
    private final String delimiterPattern;
    private final List<String> completeWords;
    private final String partialWord;

    AutoCompleteWords(String searchTerm, String delimiterPattern) {
        this.searchTerm = searchTerm == null ? "" : searchTerm;
        this.delimiterPattern = delimiterPattern;
        List<String> termWords = this.figureTermWords();
        if (termWords.isEmpty() || this.searchTerm.matches(".*" + delimiterPattern)) {
            this.completeWords = termWords;
            this.partialWord = null;
        } else {
            this.completeWords = termWords.subList(0, termWords.size() - 1);
            this.partialWord = termWords.get(termWords.size() - 1);
        }
    }

    private List<String> figureTermWords() {
        String[] array;
        ArrayList<String> list = new ArrayList<String>();
        for (String word : array = this.searchTerm.split(this.delimiterPattern)) {
            String trimmed = word.trim();
            if (trimmed.isEmpty()) continue;
            list.add(trimmed);
        }
        return Collections.unmodifiableList(list);
    }

    public String assembleQuery(String fieldNameForCompleteWords, String fieldNameForPartialWord) {
        ArrayList<String> terms = new ArrayList<String>();
        for (String word : this.completeWords) {
            terms.add(this.buildTerm(fieldNameForCompleteWords, word));
        }
        if (this.partialWord != null) {
            terms.add(this.buildTerm(fieldNameForPartialWord, this.partialWord));
        }
        String q = StringUtils.join(terms, (String)" AND ");
        log.debug((Object)("Query string is '" + q + "'"));
        return q;
    }

    private String buildTerm(String fieldName, String word) {
        return fieldName + ":\"" + word + "\"";
    }

    public String toString() {
        return "AutoCompleteWords[searchTerm='" + this.searchTerm + "', delimiterPattern='" + this.delimiterPattern + "', completeWords=" + this.completeWords + ", partialWord=" + this.partialWord + "]";
    }
}

