/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.logging;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelNames;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;

public class ToString {
    public static String ontModelToString(OntModel ontModel) {
        if (ontModel == null || ToString.isVitroClass(ontModel)) {
            return String.valueOf(ontModel);
        }
        Model base = ontModel.getBaseModel();
        Graph baseGraph = base.getGraph();
        List subGraphs = ontModel.getSubGraphs();
        return ToString.simpleName(ontModel) + "[" + ToString.hashHex(ontModel) + ", base=" + ToString.modelToString(base) + ", subgraphs=" + ToString.subGraphsToString(subGraphs, baseGraph) + "]";
    }

    private static String subGraphsToString(Collection<Graph> subGraphs, Graph baseGraph) {
        HashSet<Graph> set = new HashSet<Graph>(subGraphs);
        set.remove(baseGraph);
        return ToString.setOfGraphsToString(set);
    }

    private static String setOfGraphsToString(Set<Graph> set) {
        HashSet<String> strings = new HashSet<String>();
        for (Graph g : set) {
            strings.add(ToString.graphToString(g));
        }
        return "[" + StringUtils.join(strings, (String)", ") + "]";
    }

    public static String modelToString(Model model) {
        if (model == null || ToString.isVitroClass(model)) {
            return String.valueOf(model);
        }
        return ToString.simpleName(model) + "[" + ToString.hashHex(model) + ", base=" + ToString.graphToString(model.getGraph()) + "]";
    }

    public static String graphToString(Graph graph) {
        if (graph == null || ToString.isVitroClass(graph)) {
            return String.valueOf(graph);
        }
        if (graph instanceof Polyadic) {
            return ToString.polyadicGraphToString((Polyadic)graph);
        }
        return ToString.simpleName(graph) + "[" + ToString.hashHex(graph) + "]";
    }

    private static String polyadicGraphToString(Polyadic poly) {
        Graph baseGraph = poly.getBaseGraph();
        List subGraphs = poly.getSubGraphs();
        return ToString.simpleName(poly) + "[" + ToString.hashHex(poly) + ", base=" + ToString.graphToString(baseGraph) + ", subgraphs=" + ToString.subGraphsToString(subGraphs, baseGraph) + "]";
    }

    public static String modelName(String name) {
        if (name == null) {
            return "null";
        }
        for (Map.Entry<String, String> entry : ModelNames.namesMap.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        if (name.startsWith("http://vitro.mannlib.cornell.edu/filegraph/")) {
            return "filegraph:" + name.substring("http://vitro.mannlib.cornell.edu/filegraph/".length());
        }
        return name;
    }

    public static String replaceModelNames(String raw) {
        String s = raw;
        for (Map.Entry<String, String> entry : ModelNames.namesMap.entrySet()) {
            s = s.replace(entry.getValue(), entry.getKey());
        }
        return s.replace("http://vitro.mannlib.cornell.edu/filegraph/", "filegraph:");
    }

    public static boolean isVitroClass(Object o) {
        return o != null && o.getClass().getName().startsWith("edu.cornell");
    }

    public static String simpleName(Object o) {
        return o == null ? "null" : o.getClass().getSimpleName();
    }

    public static String hashHex(Object o) {
        return o == null ? "@00000000" : String.format("@%08x", o.hashCode());
    }

    private ToString() {
    }
}

