/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.logging;

import java.util.Stack;

public class ComplexStringFormatter {
    private final String rawString;
    private final String indentText;
    private int cursor;
    private Stack<Integer> stack = new Stack();
    private StringBuilder buffer = new StringBuilder();
    private int lineNumber;

    public ComplexStringFormatter(String rawString) {
        this(rawString, "    ");
    }

    public ComplexStringFormatter(String rawString, String indentText) {
        this.rawString = rawString;
        this.indentText = indentText;
    }

    public String toString() {
        while (this.cursor < this.rawString.length()) {
            char c = this.currentChar();
            switch (c) {
                case '[': 
                case '{': {
                    this.addChar();
                    this.pushDelimiter();
                    this.skipWhiteSpace();
                    if (this.isNextCharacter('@', '}', ']')) break;
                    this.lineBreak();
                    break;
                }
                case ',': {
                    this.addChar();
                    this.lineBreak();
                    break;
                }
                case ']': 
                case '}': {
                    boolean multiline = this.popDelimiter();
                    if (multiline) {
                        this.lineBreak();
                        this.addOneIndent();
                    }
                    this.addChar();
                    break;
                }
                default: {
                    this.addChar();
                }
            }
            this.next();
        }
        return this.buffer.toString();
    }

    private void next() {
        ++this.cursor;
    }

    private char currentChar() {
        return this.rawString.charAt(this.cursor);
    }

    private void addChar() {
        this.buffer.append(this.currentChar());
    }

    private void addOneIndent() {
        this.buffer.append(this.indentText);
    }

    private void pushDelimiter() {
        this.stack.push(this.lineNumber);
    }

    private boolean popDelimiter() {
        return this.lineNumber != this.stack.pop();
    }

    private boolean isNextCharacter(char ... chars) {
        if (this.cursor + 1 >= this.rawString.length()) {
            return false;
        }
        char nextChar = this.rawString.charAt(this.cursor + 1);
        for (char c : chars) {
            if (nextChar != c) continue;
            return true;
        }
        return false;
    }

    private void skipWhiteSpace() {
        while (this.isNextCharacter(' ', '\r', '\n', '\t')) {
            this.next();
        }
    }

    private void lineBreak() {
        this.buffer.append('\n');
        ++this.lineNumber;
        for (int i = 0; i < this.stack.size(); ++i) {
            this.addOneIndent();
        }
        this.skipWhiteSpace();
    }
}

