/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.jena;

import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class URIUtils {
    public static boolean hasExistingURI(String uriStr, OntModel ontModel) {
        ontModel.enterCriticalSection(true);
        try {
            if (URIUtils.anyStatements(ontModel, ResourceFactory.createResource((String)uriStr), null, null)) {
                boolean bl = true;
                return bl;
            }
            if (URIUtils.anyStatements(ontModel, null, ResourceFactory.createProperty((String)uriStr), null)) {
                boolean bl = true;
                return bl;
            }
            if (URIUtils.anyStatements(ontModel, null, null, (RDFNode)ResourceFactory.createResource((String)uriStr))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasEditableEntity(String uriStr, OntModel ontModel) {
        ontModel.enterCriticalSection(true);
        try {
            Resource res = ResourceFactory.createResource((String)uriStr);
            if (URIUtils.anyStatements(ontModel, res, RDF.type, (RDFNode)OWL.Thing)) {
                boolean bl = true;
                return bl;
            }
            if (URIUtils.anyStatements(ontModel, res, RDF.type, (RDFNode)OWL.Class)) {
                boolean bl = true;
                return bl;
            }
            if (URIUtils.anyStatements(ontModel, res, RDF.type, (RDFNode)OWL.DatatypeProperty)) {
                boolean bl = true;
                return bl;
            }
            if (URIUtils.anyStatements(ontModel, res, RDF.type, (RDFNode)OWL.ObjectProperty)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean anyStatements(OntModel m, Resource s, Property p, RDFNode o) {
        try (StmtIterator stmts = m.listStatements(s, p, o);){
            boolean bl = stmts.hasNext();
            return bl;
        }
    }
}

