/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.jena;

import edu.cornell.mannlib.vitro.webapp.utils.NamespaceMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;

public class NamespaceMapperJena
extends StatementListener
implements NamespaceMapper {
    private static final Log log = LogFactory.getLog(NamespaceMapperJena.class);
    private HashMap<String, String> prefixToNamespaceMap = new HashMap();
    private HashMap<String, List<String>> namespaceToPrefixMap = new HashMap();
    private HashSet<String> knownNamespaces = new HashSet();
    private OntModel metadataModel;
    private OntModel dataModel;
    private boolean pipeOpen = true;
    private String namespaceForNamespaceObjects;
    private HashSet<String> propertyURIsToListenFor;
    private static int LARGE_NS = 200;

    public NamespaceMapperJena(OntModel dataModel, OntModel metadataModel, String namespaceForNamespaceObjects) {
        this.dataModel = dataModel;
        dataModel.getBaseModel().register((ModelChangedListener)this);
        this.metadataModel = metadataModel;
        this.namespaceForNamespaceObjects = namespaceForNamespaceObjects;
        this.propertyURIsToListenFor = new HashSet();
        this.propertyURIsToListenFor.add("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasPrefixMapping");
        this.propertyURIsToListenFor.add("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isCurrentPrefixMapping");
        this.propertyURIsToListenFor.add("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespacePrefix");
        this.rebuildNamespaceCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildNamespaceCache() {
        HashMap<String, String> tempPrefixToNamespaceMap = new HashMap<String, String>();
        HashMap tempNamespaceToPrefixMap = new HashMap();
        this.metadataModel.enterCriticalSection(true);
        int nsCount = 0;
        try (ExtendedIterator closeIt = this.metadataModel.listIndividuals(this.metadataModel.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Namespace"));){
            ExtendedIterator namespaceIt = closeIt;
            while (namespaceIt.hasNext()) {
                if (++nsCount == LARGE_NS) {
                    log.warn((Object)"Unusually large number of different namespaces encountered; namespace mapper setup may take some time.");
                }
                Individual namespaceInd = (Individual)namespaceIt.next();
                String namespaceURI = null;
                RDFNode node = namespaceInd.getPropertyValue(this.metadataModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespaceURI"));
                if (node != null && node.isLiteral()) {
                    namespaceURI = ((Literal)node).getLexicalForm();
                    this.knownNamespaces.add(namespaceURI);
                }
                LinkedList<String> prefixList = new LinkedList<String>();
                try (NodeIterator closeIt2 = namespaceInd.listPropertyValues(this.metadataModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hasPrefixMapping"));){
                    NodeIterator namespacePrefixMappingIt = closeIt2;
                    while (namespacePrefixMappingIt.hasNext()) {
                        Individual namespacePrefixMappingInd;
                        RDFNode prefixValue;
                        RDFNode value = (RDFNode)namespacePrefixMappingIt.next();
                        if (!value.canAs(Individual.class) || (prefixValue = (namespacePrefixMappingInd = (Individual)value.as(Individual.class)).getPropertyValue(this.metadataModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespacePrefix"))) == null || !prefixValue.isLiteral()) continue;
                        String prefix = ((Literal)prefixValue).getLexicalForm();
                        boolean isCurrent = true;
                        RDFNode isCurrentValue = namespacePrefixMappingInd.getPropertyValue(this.metadataModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isCurrentPrefixMapping"));
                        if (isCurrentValue != null && isCurrentValue.isLiteral()) {
                            isCurrent = ((Literal)isCurrentValue).getBoolean();
                        }
                        if (isCurrent) {
                            prefixList.add(0, prefix);
                        } else {
                            prefixList.add(prefix);
                        }
                        tempPrefixToNamespaceMap.put(prefix, namespaceURI);
                    }
                }
                tempNamespaceToPrefixMap.put(namespaceURI, prefixList);
            }
        }
        finally {
            this.metadataModel.leaveCriticalSection();
        }
        this.namespaceToPrefixMap = tempNamespaceToPrefixMap;
        this.prefixToNamespaceMap = tempPrefixToNamespaceMap;
    }

    private void makeNewNamespaces(Statement s) {
        Property pred;
        LinkedList<String> namespacesToCheck = new LinkedList<String>();
        Resource subj = s.getSubject();
        if (!subj.isAnon() && subj.getNameSpace() != null) {
            namespacesToCheck.add(subj.getNameSpace());
        }
        if ((pred = s.getPredicate()).getNameSpace() != null) {
            namespacesToCheck.add(pred.getNameSpace());
        }
        if (s.getObject().isResource() && ((Resource)s.getObject()).getNameSpace() != null) {
            namespacesToCheck.add(((Resource)s.getObject()).getNameSpace());
        }
        this.processPossibleNewNamespaces(namespacesToCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPossibleNewNamespaces(List<String> namespaceList) {
        HashSet<String> newNamespaces = new HashSet<String>();
        for (String namespace : namespaceList) {
            this.metadataModel.enterCriticalSection(true);
            try {
                if (this.knownNamespaces.contains(namespace)) continue;
                newNamespaces.add(namespace);
            }
            finally {
                this.metadataModel.leaveCriticalSection();
            }
        }
        if (newNamespaces.size() > 0) {
            LinkedList<String> newNamespaceList = new LinkedList<String>();
            newNamespaceList.addAll(newNamespaces);
            this.createNewNamespaceObjects(newNamespaceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewNamespaceObjects(List<String> newNamespaces) {
        for (String newNamespace : newNamespaces) {
            this.metadataModel.enterCriticalSection(false);
            try {
                int id = 1;
                while (this.metadataModel.getIndividual(this.namespaceForNamespaceObjects + "ns" + id) != null) {
                    ++id;
                }
                Individual nsInd = this.metadataModel.createIndividual(this.namespaceForNamespaceObjects + "ns" + id, this.metadataModel.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Namespace"));
                nsInd.addProperty(this.metadataModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#namespaceURI"), newNamespace);
                this.knownNamespaces.add(newNamespace);
            }
            finally {
                this.metadataModel.leaveCriticalSection();
            }
        }
    }

    public void addedStatement(Statement s) {
        if (!this.pipeOpen) {
            return;
        }
        this.pipeOpen = false;
        this.makeNewNamespaces(s);
        String predURI = s.getPredicate().getURI();
        if (this.propertyURIsToListenFor.contains(predURI)) {
            this.rebuildNamespaceCache();
        }
        this.pipeOpen = true;
    }

    public void removedStatement(Statement s) {
        if (!this.pipeOpen) {
            return;
        }
        this.pipeOpen = false;
        String predURI = s.getPredicate().getURI();
        if (this.propertyURIsToListenFor.contains(predURI)) {
            this.rebuildNamespaceCache();
        }
        this.pipeOpen = true;
    }

    @Override
    public String getNamespaceForPrefix(String prefix) {
        return this.prefixToNamespaceMap.get(prefix);
    }

    @Override
    public String getPrefixForNamespace(String namespace) {
        List<String> prefixList = this.namespaceToPrefixMap.get(namespace);
        return prefixList == null || prefixList.size() == 0 ? null : prefixList.get(0);
    }

    @Override
    public List<String> getPrefixesForNamespace(String namespace) {
        return this.namespaceToPrefixMap.get(namespace);
    }

    public String toString() {
        return this.namespaceToPrefixMap.toString();
    }
}

