/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.jena;

import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaIngestUtils;
import edu.cornell.mannlib.vitro.webapp.utils.jena.WorkflowOntology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class JenaIngestWorkflowProcessor {
    private static final Log log = LogFactory.getLog((String)JenaIngestWorkflowProcessor.class.getName());
    private Individual workflowInd;
    private ModelMaker modelMaker;
    private Map<String, Literal> varMap = new HashMap<String, Literal>();
    private List<ActionHandler> actionHandlerList;
    private JenaIngestUtils utils;

    public JenaIngestWorkflowProcessor(Individual workflowInd, ModelMaker modelMaker) {
        this.workflowInd = workflowInd;
        this.modelMaker = modelMaker;
        this.actionHandlerList = new LinkedList<ActionHandler>();
        this.actionHandlerList.add(new ClearModelAction());
        this.actionHandlerList.add(new AddModelsAction());
        this.actionHandlerList.add(new SubtractModelsAction());
        this.actionHandlerList.add(new ExecuteSparqlConstructAction());
        this.actionHandlerList.add(new SplitPropertyValuesAction());
        this.actionHandlerList.add(new ProcessPropertyValueStringsAction());
        this.actionHandlerList.add(new SmushResourcesAction());
        this.actionHandlerList.add(new NameBlankNodesAction());
        this.utils = new JenaIngestUtils();
    }

    public void run() {
        this.run(null);
    }

    public void run(Individual startingWorkflowStep) {
        for (Individual step : this.getWorkflowSteps(startingWorkflowStep)) {
            ActionHandler handler;
            ActionResult result;
            Individual action = this.getAction(step);
            log.debug((Object)("Executing workflow action " + action.getURI()));
            Iterator<ActionHandler> iterator = this.actionHandlerList.iterator();
            while (iterator.hasNext() && (result = (handler = iterator.next()).handleAction(action)) == null) {
            }
        }
    }

    private Individual getAction(Individual stepInd) {
        log.debug((Object)("Workflow step: " + stepInd.getURI()));
        RDFNode actionNode = stepInd.getPropertyValue((Property)WorkflowOntology.action);
        if (actionNode != null && actionNode.canAs(Individual.class)) {
            return (Individual)actionNode.as(Individual.class);
        }
        return null;
    }

    public List<Individual> getWorkflowSteps(Individual startingWorkflowStep) {
        Individual currentInd;
        LinkedList<Individual> workflowSteps = new LinkedList<Individual>();
        Individual individual = currentInd = startingWorkflowStep == null ? this.getWorkflowStep(this.workflowInd.getPropertyValue((Property)WorkflowOntology.firstStep)) : startingWorkflowStep;
        while (currentInd != null) {
            workflowSteps.add(currentInd);
            currentInd = this.getWorkflowStep(currentInd.getPropertyValue((Property)WorkflowOntology.nextStep));
        }
        return workflowSteps;
    }

    private Individual getWorkflowStep(RDFNode stepNode) {
        Individual nextStepInd;
        if (stepNode == null) {
            return null;
        }
        if (stepNode != null && stepNode.canAs(Individual.class) && this.instanceOf(nextStepInd = (Individual)stepNode.as(Individual.class), (Resource)WorkflowOntology.WorkflowStep)) {
            return nextStepInd;
        }
        return null;
    }

    private boolean instanceOf(Individual ind, Resource type) {
        for (Resource typeRes : ind.listRDFTypes(false).toList()) {
            if (typeRes.isAnon() || !typeRes.getURI().equals(type.getURI())) continue;
            return true;
        }
        return false;
    }

    private Literal getValue(RDFNode valueIndNode) {
        RDFNode variableNameNode;
        Individual valueInd = (Individual)valueIndNode.as(Individual.class);
        if (this.instanceOf(valueInd, (Resource)WorkflowOntology.Literal)) {
            RDFNode valueNode = valueInd.getPropertyValue((Property)WorkflowOntology.literalValue);
            if (valueNode != null && valueNode.isLiteral()) {
                return (Literal)valueNode.as(Literal.class);
            }
        } else if (this.instanceOf(valueInd, (Resource)WorkflowOntology.Variable) && (variableNameNode = valueInd.getPropertyValue((Property)WorkflowOntology.variableName)) != null && variableNameNode.isLiteral()) {
            return this.varMap.get(((Literal)variableNameNode.as(Literal.class)).getLexicalForm());
        }
        return null;
    }

    private Model getModel(RDFNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        Individual modelInd = (Individual)modelNode.as(Individual.class);
        String modelNameStr = ((Literal)modelInd.getPropertyValue((Property)WorkflowOntology.modelName).as(Literal.class)).getLexicalForm();
        return this.modelMaker.createModel(modelNameStr, false);
    }

    private class ProcessPropertyValueStringsAction
    implements ActionHandler {
        private ProcessPropertyValueStringsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.ProcessPropertyValueStringsAction)) {
                OntModel sourceModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                for (RDFNode node : actionInd.listPropertyValues((Property)WorkflowOntology.sourceModel).toList()) {
                    sourceModel.addSubModel(JenaIngestWorkflowProcessor.this.getModel(node));
                }
                Model destinationModel = null;
                try {
                    destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                }
                catch (Exception node) {
                    // empty catch block
                }
                Model additionsModel = null;
                try {
                    additionsModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.additionsModel));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Model retractionsModel = null;
                try {
                    retractionsModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.retractionsModel));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String processorClass = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.processorClass)).getLexicalForm();
                String processorMethod = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.processorMethod)).getLexicalForm();
                String propertyURI = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.originalProperty)).getLexicalForm();
                String newPropertyURI = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.newProperty)).getLexicalForm();
                destinationModel.enterCriticalSection(false);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"calling processPropertyValueStrings ...");
                    }
                    JenaIngestWorkflowProcessor.this.utils.processPropertyValueStrings((Model)sourceModel, destinationModel, additionsModel, retractionsModel, processorClass, processorMethod, propertyURI, newPropertyURI);
                }
                finally {
                    destinationModel.leaveCriticalSection();
                }
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class SplitPropertyValuesAction
    implements ActionHandler {
        private SplitPropertyValuesAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.SplitPropertyValuesAction)) {
                OntModel sourceModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                for (RDFNode node : actionInd.listPropertyValues((Property)WorkflowOntology.sourceModel).toList()) {
                    sourceModel.addSubModel(JenaIngestWorkflowProcessor.this.getModel(node));
                }
                Model destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                String propertyURI = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.originalProperty)).getLexicalForm();
                String newPropertyURI = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.newProperty)).getLexicalForm();
                String splitRegex = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.splitRegex)).getLexicalForm();
                boolean trim = true;
                try {
                    trim = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.trim)).getBoolean();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                destinationModel.enterCriticalSection(false);
                try {
                    destinationModel.add(JenaIngestWorkflowProcessor.this.utils.splitPropertyValues((Model)sourceModel, propertyURI, splitRegex, newPropertyURI, trim));
                }
                finally {
                    destinationModel.leaveCriticalSection();
                }
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class NameBlankNodesAction
    implements ActionHandler {
        private NameBlankNodesAction() {
        }

        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.NameBlankNodesAction)) {
                OntModel sourceModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                for (RDFNode node : actionInd.listPropertyValues((Property)WorkflowOntology.sourceModel).toList()) {
                    sourceModel.addSubModel(JenaIngestWorkflowProcessor.this.getModel(node));
                }
                Model destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                String uriPrefix = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.uriPrefix)).getLexicalForm();
                destinationModel.add(JenaIngestWorkflowProcessor.this.utils.renameBNodes((Model)sourceModel, uriPrefix));
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class SmushResourcesAction
    implements ActionHandler {
        private SmushResourcesAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.SmushResourcesAction)) {
                OntModel sourceModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                for (RDFNode node : actionInd.listPropertyValues((Property)WorkflowOntology.sourceModel).toList()) {
                    sourceModel.addSubModel(JenaIngestWorkflowProcessor.this.getModel(node));
                }
                Model destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                String smushPropertyURI = JenaIngestWorkflowProcessor.this.getValue(actionInd.getPropertyValue((Property)WorkflowOntology.smushOnProperty)).getLexicalForm();
                destinationModel.enterCriticalSection(false);
                try {
                    destinationModel.add(JenaIngestWorkflowProcessor.this.utils.smushResources((Model)sourceModel, ResourceFactory.createProperty((String)smushPropertyURI)));
                }
                finally {
                    destinationModel.leaveCriticalSection();
                }
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class ExecuteSparqlConstructAction
    implements ActionHandler {
        private static final String QUERY_STR_PROPERTY = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7/sparql#queryStr";

        private ExecuteSparqlConstructAction() {
        }

        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.SPARQLCONSTRUCTAction)) {
                OntModel sourceModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                for (RDFNode node : actionInd.listPropertyValues((Property)WorkflowOntology.sourceModel).toList()) {
                    log.debug((Object)"SPARQL: adding submodel ");
                    sourceModel.addSubModel(JenaIngestWorkflowProcessor.this.getModel(node));
                }
                if (actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel) == null) {
                    log.debug((Object)"Error: destination model for SPARQL Construct action not specified for this action");
                    return null;
                }
                Model destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                Model tempModel = ModelFactory.createDefaultModel();
                OntResource sparqlQuery = (OntResource)actionInd.getPropertyValue((Property)WorkflowOntology.sparqlQuery);
                String queryStr = ((Literal)sparqlQuery.getPropertyValue(ResourceFactory.createProperty((String)QUERY_STR_PROPERTY))).getLexicalForm();
                log.debug((Object)("SPARQL query: \n" + queryStr));
                Query query = QueryFactory.create((String)queryStr, (Syntax)Syntax.syntaxARQ);
                QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)sourceModel);
                qexec.execConstruct(tempModel);
                destinationModel.add(tempModel);
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class SubtractModelsAction
    implements ActionHandler {
        private SubtractModelsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.SubtractModelAction)) {
                block12: {
                    Model sourceModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.sourceModel));
                    Model modelToSubtract = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.modelToSubtract));
                    Model destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                    Boolean applyChangesDirectlyToSource = false;
                    RDFNode valueNode = actionInd.getPropertyValue((Property)WorkflowOntology.applyChangesDirectlyToSource);
                    if (valueNode != null && valueNode.isLiteral()) {
                        applyChangesDirectlyToSource = ((Literal)valueNode.as(Literal.class)).getBoolean();
                    }
                    sourceModel.enterCriticalSection(false);
                    try {
                        modelToSubtract.enterCriticalSection(true);
                        try {
                            if (applyChangesDirectlyToSource.booleanValue()) {
                                sourceModel.remove(modelToSubtract);
                                break block12;
                            }
                            destinationModel.enterCriticalSection(false);
                            try {
                                destinationModel.add(sourceModel.difference(modelToSubtract));
                            }
                            finally {
                                destinationModel.leaveCriticalSection();
                            }
                        }
                        finally {
                            modelToSubtract.leaveCriticalSection();
                        }
                    }
                    finally {
                        sourceModel.leaveCriticalSection();
                    }
                }
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class AddModelsAction
    implements ActionHandler {
        private AddModelsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.AddModelAction)) {
                block12: {
                    Model sourceModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.sourceModel));
                    Model modelToAdd = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.modelToAdd));
                    Model destinationModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.destinationModel));
                    Boolean applyChangesDirectlyToSource = false;
                    RDFNode valueNode = actionInd.getPropertyValue((Property)WorkflowOntology.applyChangesDirectlyToSource);
                    if (valueNode != null && valueNode.isLiteral()) {
                        applyChangesDirectlyToSource = ((Literal)valueNode.as(Literal.class)).getBoolean();
                    }
                    sourceModel.enterCriticalSection(false);
                    try {
                        modelToAdd.enterCriticalSection(true);
                        try {
                            if (applyChangesDirectlyToSource.booleanValue()) {
                                sourceModel.add(modelToAdd);
                                break block12;
                            }
                            destinationModel.enterCriticalSection(false);
                            try {
                                destinationModel.add(modelToAdd);
                            }
                            finally {
                                destinationModel.leaveCriticalSection();
                            }
                        }
                        finally {
                            modelToAdd.leaveCriticalSection();
                        }
                    }
                    finally {
                        sourceModel.leaveCriticalSection();
                    }
                }
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private class ClearModelAction
    implements ActionHandler {
        private ClearModelAction() {
        }

        @Override
        public ActionResult handleAction(Individual actionInd) {
            if (JenaIngestWorkflowProcessor.this.instanceOf(actionInd, (Resource)WorkflowOntology.ClearModelAction)) {
                Model sourceModel = JenaIngestWorkflowProcessor.this.getModel(actionInd.getPropertyValue((Property)WorkflowOntology.sourceModel));
                sourceModel.enterCriticalSection(false);
                try {
                    sourceModel.removeAll((Resource)null, (Property)null, (RDFNode)null);
                }
                finally {
                    sourceModel.leaveCriticalSection();
                }
                return new ActionResultImpl();
            }
            return null;
        }
    }

    private static interface ActionHandler {
        public ActionResult handleAction(Individual var1);
    }

    private class ActionResultImpl
    implements ActionResult {
        private ActionResultImpl() {
        }
    }

    private static interface ActionResult {
    }
}

