/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;

public class SparqlQueryRunner {
    private static final Log log = LogFactory.getLog(SparqlQueryRunner.class);
    private static final Syntax SYNTAX = Syntax.syntaxARQ;
    private final Model model;

    public SparqlQueryRunner(Model model) {
        if (model == null) {
            throw new NullPointerException("model may not be null.");
        }
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeSelect(QueryParser<T> parser, String queryStr) {
        if (parser == null) {
            throw new NullPointerException("parser may not be null.");
        }
        if (queryStr == null) {
            throw new NullPointerException("queryStr may not be null.");
        }
        log.debug((Object)("select query is: '" + queryStr + "'"));
        try (QueryExecution qe = null;){
            Query query = QueryFactory.create((String)queryStr, (Syntax)SYNTAX);
            qe = QueryExecutionFactory.create((Query)query, (Model)this.model);
            T t = parser.parseResults(queryStr, qe.execSelect());
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model executeConstruct(String queryStr) {
        log.debug((Object)("construct query is: '" + queryStr + "'"));
        try (QueryExecution qe = null;){
            Query query = QueryFactory.create((String)queryStr, (Syntax)SYNTAX);
            qe = QueryExecutionFactory.create((Query)query, (Model)this.model);
            Model model = qe.execConstruct();
            return model;
        }
    }

    public static String bindValues(String rawString, VariableValue ... values) {
        String queryString = rawString;
        for (VariableValue value : values) {
            queryString = value.bind(queryString);
        }
        return queryString;
    }

    public static UriValue uriValue(String name, String uri) {
        return new UriValue(name, uri);
    }

    private static class UriValue
    implements VariableValue {
        private final String name;
        private final String uri;

        public UriValue(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        @Override
        public String bind(String rawString) {
            return rawString.replaceAll("\\?" + this.name + "\\b", "<" + this.uri + ">");
        }
    }

    public static interface VariableValue {
        public String bind(String var1);
    }

    public static abstract class QueryParser<T> {
        protected abstract T parseResults(String var1, ResultSet var2);

        protected abstract T defaultValue();

        protected String ifResourcePresent(QuerySolution solution, String variableName, String defaultValue) {
            RDFNode node = solution.get(variableName);
            if (node == null || !node.isURIResource()) {
                return defaultValue;
            }
            return node.asResource().getURI();
        }

        protected String ifLiteralPresent(QuerySolution solution, String variableName, String defaultValue) {
            Literal literal = solution.getLiteral(variableName);
            if (literal == null) {
                return defaultValue;
            }
            return literal.getString();
        }

        protected long ifLongPresent(QuerySolution solution, String variableName, long defaultValue) {
            Literal literal = solution.getLiteral(variableName);
            if (literal == null) {
                return defaultValue;
            }
            return literal.getLong();
        }

        protected int ifIntPresent(QuerySolution solution, String variableName, int defaultValue) {
            Literal literal = solution.getLiteral(variableName);
            if (literal == null) {
                return defaultValue;
            }
            return literal.getInt();
        }
    }
}

