/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.sparql;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.MemoryMappingModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.ModelMakerWithPersistentEmptyModels;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ContentTripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceFactorySingle;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.LoggingRDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.sparql.RDFServiceSparql;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.ModelMaker;

public class ContentTripleSourceSPARQL
extends ContentTripleSource {
    private String endpointURI;
    private String updateEndpointURI;
    private RDFService rdfService;
    private RDFServiceFactory rdfServiceFactory;
    private Dataset dataset;
    private ModelMaker modelMaker;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasEndpointURI", minOccurs=1, maxOccurs=1)
    public void setEndpointURI(String eUri) {
        this.endpointURI = eUri;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasUpdateEndpointURI", maxOccurs=1)
    public void setUpdateEndpointURI(String ueUri) {
        this.updateEndpointURI = ueUri;
    }

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        this.rdfServiceFactory = this.createRDFServiceFactory(this.createRDFService(ss));
        this.rdfService = this.rdfServiceFactory.getRDFService();
        this.dataset = this.createDataset();
        this.modelMaker = this.createModelMaker();
    }

    protected RDFService createRDFService(ComponentStartupStatus ss) {
        if (this.updateEndpointURI == null) {
            ss.info("Using endpoint at " + this.endpointURI);
            return new RDFServiceSparql(this.endpointURI);
        }
        ss.info("Using read endpoint at " + this.endpointURI + " and update endpoint at " + this.updateEndpointURI);
        return new RDFServiceSparql(this.endpointURI, this.updateEndpointURI);
    }

    private RDFServiceFactory createRDFServiceFactory(RDFService service) {
        return new LoggingRDFServiceFactory(new RDFServiceFactorySingle(service));
    }

    private Dataset createDataset() {
        return new RDFServiceDataset(this.getRDFService());
    }

    private ModelMaker createModelMaker() {
        return ContentTripleSourceSPARQL.addContentDecorators(new ModelMakerWithPersistentEmptyModels(new MemoryMappingModelMaker(new RDFServiceModelMaker(this.getRDFService()), SMALL_CONTENT_MODELS)));
    }

    @Override
    public RDFServiceFactory getRDFServiceFactory() {
        return this.rdfServiceFactory;
    }

    @Override
    public RDFService getRDFService() {
        return this.rdfService;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public ModelMaker getModelMaker() {
        return this.modelMaker;
    }

    @Override
    public OntModelCache getShortTermOntModels(RDFService shortTermRdfService, OntModelCache longTermOntModelCache) {
        return longTermOntModelCache;
    }

    public String toString() {
        return "ContentTripleSourceSPARQL[" + ToString.hashHex(this) + ", endpointURI=" + this.endpointURI + ", updateEndpointURI=" + this.updateEndpointURI + "]";
    }

    @Override
    public void shutdown(Application application) {
        if (this.rdfService != null) {
            this.rdfService.close();
        }
    }
}

