/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb.SDBDataSource;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.servlet.ServletContext;

public class SDBConnectionSmokeTests {
    private final ConfigurationProperties props;
    private final ComponentStartupStatus ss;

    public SDBConnectionSmokeTests(ServletContext ctx, ComponentStartupStatus ss) {
        this.props = ConfigurationProperties.getBean(ctx);
        this.ss = ss;
    }

    public void checkDatabaseConnection() {
        Properties connectionProps;
        String url;
        block19: {
            url = this.props.getProperty("VitroConnection.DataSource.url");
            if (url == null || url.isEmpty()) {
                this.ss.fatal("runtime.properties does not contain a value for 'VitroConnection.DataSource.url'");
                return;
            }
            url = SDBDataSource.getJdbcUrl(this.props);
            String username = this.props.getProperty("VitroConnection.DataSource.username");
            if (username == null || username.isEmpty()) {
                this.ss.fatal("runtime.properties does not contain a value for 'VitroConnection.DataSource.username'");
                return;
            }
            String password = this.props.getProperty("VitroConnection.DataSource.password");
            if (password == null || password.isEmpty()) {
                this.ss.fatal("runtime.properties does not contain a value for 'VitroConnection.DataSource.password'");
                return;
            }
            String driverClassName = this.props.getProperty("VitroConnection.DataSource.driver");
            if (driverClassName == null) {
                try {
                    Class.forName("com.mysql.jdbc.Driver").newInstance();
                }
                catch (Exception e) {
                    this.ss.fatal("The default Database Driver failed to load. The driver class is 'com.mysql.jdbc.Driver'", e);
                    return;
                }
            }
            try {
                Class.forName(driverClassName).newInstance();
            }
            catch (Exception e) {
                this.ss.fatal("The Database Driver failed to load. The driver class was set by VitroConnection.DataSource.driver to be '" + driverClassName + "'", e);
                return;
            }
            connectionProps = new Properties();
            connectionProps.put("user", username);
            connectionProps.put("password", password);
            try (Connection conn = DriverManager.getConnection(url, connectionProps);){
                String skip = this.props.getProperty("skip.Jena3StringTest", "false");
                if (Boolean.parseBoolean(skip)) break block19;
                try {
                    long total;
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("SELECT COUNT(1) AS total FROM Nodes WHERE datatype='http://www.w3.org/2001/XMLSchema#string'");
                    if (rs != null && rs.next() && (total = rs.getLong("total")) > 0L) {
                        this.ss.fatal("XSD Strings exist in Nodes table. Requires upgrade for Jena 3");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                this.ss.fatal("Can't connect to the database: VitroConnection.DataSource.url='" + url + "', " + "VitroConnection.DataSource.username" + "='" + username + "'", e);
                return;
            }
        }
        String dbType = this.props.getProperty("VitroConnection.DataSource.dbtype", "MySQL");
        this.checkForPropertHandlingOfUnicodeCharacters(url, connectionProps, dbType);
    }

    private void checkForPropertHandlingOfUnicodeCharacters(String url, Properties connectionProps, String dbType) {
        String testString = "ABC\u00ce\u0123";
        try (Connection conn = DriverManager.getConnection(url, connectionProps);
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TEMPORARY TABLE smoke_test (contents varchar(100))");
            try (PreparedStatement pstmt = conn.prepareStatement("INSERT INTO smoke_test values ( ? )");){
                pstmt.setBytes(1, testString.getBytes("UTF-8"));
                pstmt.executeUpdate();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            ResultSet rs = stmt.executeQuery("SELECT * FROM smoke_test");
            if (!rs.next()) {
                throw new SQLException("Query of temporary table returned 0 rows.");
            }
            String storedValue = rs.getString(1);
            if (!testString.equals(storedValue)) {
                String message = "The database does not store Unicode characters correctly. The test inserted \"" + this.showUnicode(testString) + "\", but the query returned \"" + this.showUnicode(storedValue) + "\". Is the character encoding correctly set on the database?";
                if ("MySQL".equals(dbType)) {
                    this.ss.fatal(message);
                } else {
                    this.ss.warning(message);
                }
            }
        }
        catch (SQLException e) {
            this.ss.fatal("Failed to check handling of Unicode characters", e);
        }
    }

    private String showUnicode(String testString) {
        StringBuilder u = new StringBuilder();
        for (char c : testString.toCharArray()) {
            u.append(String.format("\\u%04x", c & 0xFFFF));
        }
        return u.toString();
    }
}

