/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.JoinedOntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.TripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringUtils;
import edu.cornell.mannlib.vitro.webapp.triplesource.ShortTermCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.BasicCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicShortTermCombinedTripleSource
implements ShortTermCombinedTripleSource {
    private static final Log log = LogFactory.getLog(BasicShortTermCombinedTripleSource.class);
    private final HttpServletRequest req;
    private final ServletContext ctx;
    private final ConfigurationProperties props;
    private final BasicCombinedTripleSource parent;
    private final Map<ModelAccess.WhichService, TripleSource> sources;
    private final Map<ModelAccess.WhichService, RDFService> rdfServices;
    private final OntModelCache ontModelCache;

    public BasicShortTermCombinedTripleSource(HttpServletRequest req, BasicCombinedTripleSource parent, Map<ModelAccess.WhichService, TripleSource> sources) {
        this.req = req;
        this.ctx = req.getSession().getServletContext();
        this.props = ConfigurationProperties.getBean(this.ctx);
        this.parent = parent;
        this.sources = sources;
        this.rdfServices = this.populateRdfServicesMap();
        this.ontModelCache = this.createOntModelCache();
    }

    private Map<ModelAccess.WhichService, RDFService> populateRdfServicesMap() {
        EnumMap<ModelAccess.WhichService, RDFService> map = new EnumMap<ModelAccess.WhichService, RDFService>(ModelAccess.WhichService.class);
        for (ModelAccess.WhichService which : ModelAccess.WhichService.values()) {
            map.put(which, this.parent.getRDFServiceFactory(which).getShortTermRDFService());
        }
        return Collections.unmodifiableMap(map);
    }

    private OntModelCache createOntModelCache() {
        return new JoinedOntModelCache(this.shortModels(ModelAccess.WhichService.CONTENT), this.shortModels(ModelAccess.WhichService.CONFIGURATION));
    }

    private OntModelCache shortModels(ModelAccess.WhichService which) {
        return this.sources.get(which).getShortTermOntModels(this.rdfServices.get(which), this.parent.getOntModels(which));
    }

    @Override
    public RDFService getRDFService(ModelAccess.WhichService whichService) {
        return this.rdfServices.get(whichService);
    }

    @Override
    public OntModelCache getOntModelCache() {
        return this.ontModelCache;
    }

    @Override
    public WebappDaoFactoryConfig getWebappDaoFactoryConfig() {
        List<String> langs = this.getPreferredLanguages();
        ArrayList<Locale> locales = Collections.list(this.getPreferredLocales());
        WebappDaoFactoryConfig config = new WebappDaoFactoryConfig();
        config.setDefaultNamespace(this.props.getProperty("Vitro.defaultNamespace"));
        config.setPreferredLanguages(langs);
        config.setPreferredLocales(locales);
        config.setUnderlyingStoreReasoned(this.isStoreReasoned());
        config.setCustomListViewConfigFileMap(this.getCustomListViewConfigFileMap());
        return config;
    }

    private List<String> getPreferredLanguages() {
        log.debug((Object)("Accept-Language: " + this.req.getHeader("Accept-Language")));
        return LanguageFilteringUtils.localesToLanguages(this.getPreferredLocales());
    }

    private Enumeration<Locale> getPreferredLocales() {
        return this.req.getLocales();
    }

    private boolean isStoreReasoned() {
        String isStoreReasoned = this.props.getProperty("VitroConnection.DataSource.isStoreReasoned", "true");
        return "true".equals(isStoreReasoned);
    }

    private Map<PropertyDao.FullPropertyKey, String> getCustomListViewConfigFileMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.ctx.getAttribute("customListViewConfigFileMap");
        if (map == null) {
            map = new ConcurrentHashMap();
            this.ctx.setAttribute("customListViewConfigFileMap", map);
        }
        return map;
    }

    @Override
    public void close() {
        for (ModelAccess.WhichService which : ModelAccess.WhichService.values()) {
            this.rdfServices.get(which).close();
        }
    }

    public String toString() {
        return "BasicShortTermCombinedTripleSource[" + ToString.hashHex(this) + ", req=" + ToString.hashHex(this.req) + ", sources=" + this.sources + ", ontModels=" + this.ontModelCache + "]";
    }
}

