/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.JenaDataSourceSetupBase;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.RDFFilesLoader;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.vocabulary.RDF;

public class ContentModelSetup
extends JenaDataSourceSetupBase
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ContentModelSetup.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        long begin = System.currentTimeMillis();
        this.setUpJenaDataSource(ctx);
        ss.info(this, this.secondsSince(begin) + " seconds to set up models and DAO factories");
    }

    private void setUpJenaDataSource(ServletContext ctx) {
        ContextModelAccess models = ModelAccess.on(ctx);
        boolean firstTimeStartup = false;
        OntModel applicationMetadataModel = models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata");
        if (applicationMetadataModel.isEmpty()) {
            firstTimeStartup = true;
            this.initializeApplicationMetadata(ctx, (Model)applicationMetadataModel);
            OntModel applicationMetadataModelFirsttime = models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadataFirsttimeBackup");
            applicationMetadataModelFirsttime.add((Model)applicationMetadataModel);
        } else {
            this.applyFirstTimeChanges(ctx);
            this.checkForNamespaceMismatch((Model)applicationMetadataModel, ctx);
        }
        OntModel baseABoxModel = models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
        if (firstTimeStartup) {
            RDFFilesLoader.loadFirstTimeFiles(ctx, "abox", (Model)baseABoxModel, true);
            OntModel baseABoxModelFirsttime = models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2FirsttimeBackup");
            baseABoxModelFirsttime.add((Model)baseABoxModel);
        }
        RDFFilesLoader.loadEveryTimeFiles(ctx, "abox", baseABoxModel);
        OntModel baseTBoxModel = models.getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
        if (firstTimeStartup) {
            RDFFilesLoader.loadFirstTimeFiles(ctx, "tbox", (Model)baseTBoxModel, true);
            OntModel baseTBoxModelFirsttime = models.getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tboxFirsttimeBackup");
            baseTBoxModelFirsttime.add((Model)baseTBoxModel);
        }
        RDFFilesLoader.loadEveryTimeFiles(ctx, "tbox", baseTBoxModel);
    }

    private long secondsSince(long startTime) {
        return (System.currentTimeMillis() - startTime) / 1000L;
    }

    private void initializeApplicationMetadata(ServletContext ctx, Model applicationMetadataModel) {
        OntModel temporaryAMModel = VitroModelFactory.createOntologyModel();
        RDFFilesLoader.loadFirstTimeFiles(ctx, "applicationMetadata", (Model)temporaryAMModel, true);
        this.setPortalUriOnFirstTime((Model)temporaryAMModel, ctx);
        applicationMetadataModel.add((Model)temporaryAMModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPortalUriOnFirstTime(Model model, ServletContext ctx) {
        ArrayList<Resource> toRename = new ArrayList<Resource>();
        try (ResIterator portalResIt = model.listSubjectsWithProperty(RDF.type, (RDFNode)model.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Portal"));){
            while (portalResIt.hasNext()) {
                Resource portalRes = (Resource)portalResIt.next();
                if (!portalRes.isAnon()) continue;
                toRename.add(portalRes);
            }
        }
        for (Resource portalResource : toRename) {
            ResourceUtils.renameResource((Resource)portalResource, (String)(this.getDefaultNamespace(ctx) + "portal1"));
        }
    }

    private void checkForNamespaceMismatch(Model model, ServletContext ctx) {
        String expectedNamespace = this.getDefaultNamespace(ctx);
        List<Resource> portals = this.getPortal1s(model);
        if (!portals.isEmpty() && this.noPortalForNamespace(portals, expectedNamespace)) {
            Resource portal = portals.get(0);
            String oldNamespace = portal.getNameSpace();
            this.renamePortal(portal, expectedNamespace, model);
            StartupStatus ss = StartupStatus.getBean(ctx);
            ss.warning(this, "\nThe default namespace has been changed \nfrom " + oldNamespace + "\nto " + expectedNamespace + ".\nThe application will function normally, but any individuals in the \n" + oldNamespace + " namespace will need to have their URIs \nchanged in order to be served as linked data. You can use the Ingest Tools \nto change the URIs for a batch of resources.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Resource> getPortal1s(Model model) {
        ArrayList<Resource> portals = new ArrayList<Resource>();
        try {
            model.enterCriticalSection(true);
            ResIterator portalIt = model.listResourcesWithProperty(RDF.type, (RDFNode)this.PORTAL);
            while (portalIt.hasNext()) {
                Resource portal = portalIt.nextResource();
                if (!"portal1".equals(portal.getLocalName())) continue;
                portals.add(portal);
            }
        }
        finally {
            model.leaveCriticalSection();
        }
        return portals;
    }

    private boolean noPortalForNamespace(List<Resource> portals, String expectedNamespace) {
        for (Resource portal : portals) {
            if (!expectedNamespace.equals(portal.getNameSpace())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renamePortal(Resource portal, String namespace, Model model) {
        model.enterCriticalSection(false);
        try {
            ResourceUtils.renameResource((Resource)portal, (String)(namespace + portal.getLocalName()));
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private void applyFirstTimeChanges(ServletContext ctx) {
        this.applyFirstTimeChanges(ctx, "applicationMetadata", "http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadataFirsttimeBackup", "http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata");
        this.applyFirstTimeChanges(ctx, "abox", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2FirsttimeBackup", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
        this.applyFirstTimeChanges(ctx, "tbox", "http://vitro.mannlib.cornell.edu/default/asserted-tboxFirsttimeBackup", "http://vitro.mannlib.cornell.edu/default/asserted-tbox");
    }

    private void applyFirstTimeChanges(ServletContext ctx, String modelPath, String firsttimeBackupModelUri, String userModelUri) {
        log.info((Object)("Reload firsttime files on start-up if changed: '" + modelPath + "', URI: '" + userModelUri + "'"));
        ContextModelAccess models = ModelAccess.on(ctx);
        OntModel firsttimeBackupModel = models.getOntModel(firsttimeBackupModelUri);
        log.debug((Object)("compare firsttime files with configuration models (backup from first start) for " + modelPath));
        OntModel firsttimeFilesModel = VitroModelFactory.createOntologyModel();
        RDFFilesLoader.loadFirstTimeFiles(ctx, modelPath, (Model)firsttimeFilesModel, true);
        if (firsttimeBackupModelUri.equals("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadataFirsttimeBackup")) {
            this.setPortalUriOnFirstTime((Model)firsttimeFilesModel, ctx);
        }
        if (RDFFilesLoader.areIsomporphic((Model)firsttimeBackupModel, (Model)firsttimeFilesModel)) {
            log.debug((Object)("They are the same, so do nothing: '" + modelPath + "'"));
        } else {
            log.debug((Object)("They differ: '" + modelPath + "', compare values in configuration models with user's triplestore"));
            OntModel userModel = models.getOntModel(userModelUri);
            boolean updatedFiles = this.applyChanges((Model)firsttimeBackupModel, (Model)firsttimeFilesModel, (Model)userModel, modelPath);
            if (updatedFiles) {
                log.info((Object)("The model was updated, " + modelPath));
            }
        }
    }

    private boolean applyChanges(Model baseModel, Model newModel, Model userModel, String modelIdString) {
        boolean updatedFiles = false;
        StringWriter out = new StringWriter();
        StringWriter out2 = new StringWriter();
        Model difOldNew = baseModel.difference(newModel);
        Model difNewOld = newModel.difference(baseModel);
        if (modelIdString.equals("applicationMetadata")) {
            Property p = userModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#", "rootTab");
            difOldNew.removeAll(null, p, null);
            difNewOld.removeAll(null, p, null);
        }
        if (difOldNew.isEmpty() && difNewOld.isEmpty()) {
            log.debug((Object)("For the " + modelIdString + " model, there is no difference in both directions. So do nothing."));
        } else {
            if (!difOldNew.isEmpty()) {
                difOldNew.write((Writer)out, "TTL");
                log.debug((Object)("Difference for " + modelIdString + " (old -> new), these triples should be removed: " + out));
                RDFFilesLoader.removeChangesThatConflictWithUIEdits(baseModel, userModel, difOldNew);
                if (userModel.containsAny(difOldNew)) {
                    log.debug((Object)"Some of these triples are in the user triples store, so they will be removed now");
                    userModel.remove(difOldNew);
                    updatedFiles = true;
                }
                baseModel.remove(difOldNew);
            }
            if (!difNewOld.isEmpty()) {
                difNewOld.write((Writer)out2, "TTL");
                log.debug((Object)("Difference for " + modelIdString + " (new -> old), these triples should be added: " + out2));
                RDFFilesLoader.removeChangesThatConflictWithUIEdits(baseModel, userModel, difNewOld);
                if (!userModel.containsAll(difNewOld)) {
                    log.debug((Object)"Some of these triples are not in the user triples store, so they will be added now");
                    Model tmp = difNewOld.difference(userModel);
                    userModel.add(tmp);
                    updatedFiles = true;
                }
                baseModel.add(difNewOld);
            }
        }
        return updatedFiles;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

