/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.tasks;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineNotRespondingException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerUtils;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.joda.time.DateTime;
import org.jsoup.Jsoup;

public class UpdateDocumentWorkUnit
implements Runnable {
    private static final Log log = LogFactory.getLog(UpdateDocumentWorkUnit.class);
    private static final String URI_OWL_THING = OWL.Thing.getURI();
    private static final String URI_DIFFERENT_FROM = OWL.differentFrom.getURI();
    private static final String URI_RDFS_LABEL = RDFS.label.getURI();
    private final Individual ind;
    private final DocumentModifierList modifiers;
    private final SearchEngine searchEngine;

    public UpdateDocumentWorkUnit(Individual ind, DocumentModifierList modifiers) {
        this.ind = ind;
        this.modifiers = modifiers;
        this.searchEngine = ApplicationUtils.instance().getSearchEngine();
    }

    public Individual getInd() {
        return this.ind;
    }

    @Override
    public void run() {
        try {
            SearchInputDocument doc = this.searchEngine.createInputDocument();
            this.modifiers.modifyDocument(this.ind, doc);
            this.addIndexedTime(doc);
            this.searchEngine.add(doc);
        }
        catch (SearchEngineNotRespondingException e) {
            log.warn((Object)("Failed to add '" + this.ind + "' to the search index: the search engine is not responding."));
        }
        catch (Exception e) {
            log.warn((Object)("Failed to add '" + this.ind + "' to the search index."), (Throwable)e);
        }
    }

    private void addIndexedTime(SearchInputDocument doc) {
        doc.addField("indexedTime", new DateTime().getMillis());
    }

    private static class AddEntityBoost
    extends BaseDocumentModifier {
        private AddEntityBoost() {
        }

        @Override
        public void modifyDocument(Individual ind, SearchInputDocument doc) {
            Float boost = ind.getSearchBoost();
            if (boost != null && !boost.equals(Float.valueOf(0.0f))) {
                doc.setDocumentBoost(boost.floatValue());
            }
        }

        public String toString() {
            return "Internal: AddEntityBoost";
        }
    }

    private static class AddDataPropertyText
    extends BaseDocumentModifier {
        private AddDataPropertyText() {
        }

        @Override
        public void modifyDocument(Individual ind, SearchInputDocument doc) {
            List<DataPropertyStatement> stmts = ind.getDataPropertyStatements();
            if (stmts != null) {
                for (DataPropertyStatement stmt : stmts) {
                    if (stmt.getDatapropURI().equals(URI_RDFS_LABEL)) continue;
                    this.addToAlltext(doc, stmt.getData());
                }
            }
        }

        public String toString() {
            return "Internal: AddDataPropertyText";
        }
    }

    private static class AddObjectPropertyText
    extends BaseDocumentModifier {
        private AddObjectPropertyText() {
        }

        @Override
        public void modifyDocument(Individual ind, SearchInputDocument doc) {
            List<ObjectPropertyStatement> stmts = ind.getObjectPropertyStatements();
            if (stmts != null) {
                for (ObjectPropertyStatement stmt : stmts) {
                    if (URI_DIFFERENT_FROM.equals(stmt.getPropertyURI())) continue;
                    this.addToAlltext(doc, stmt.getObject().getRdfsLabel());
                }
            }
        }

        public String toString() {
            return "Internal: AddObjectPropertyText";
        }
    }

    private static class AddMostSpecificTypes
    extends BaseDocumentModifier {
        private AddMostSpecificTypes() {
        }

        @Override
        public void modifyDocument(Individual ind, SearchInputDocument doc) {
            List<String> mstURIs = ind.getMostSpecificTypeURIs();
            if (mstURIs != null) {
                for (String typeURI : mstURIs) {
                    if (!StringUtils.isNotBlank((CharSequence)typeURI)) continue;
                    doc.addField("mostSpecificTypeURIs", typeURI);
                }
            }
        }

        public String toString() {
            return "Internal: AddMostSpecificTypes";
        }
    }

    private static class AddClasses
    extends BaseDocumentModifier {
        private AddClasses() {
        }

        @Override
        public void modifyDocument(Individual ind, SearchInputDocument doc) {
            List<VClass> vclasses = ind.getVClasses(false);
            if (vclasses == null) {
                return;
            }
            HashSet<String> classGroupUris = new HashSet<String>();
            for (VClass clz : vclasses) {
                Float boost;
                String classUri = clz.getURI();
                if (classUri == null || URI_OWL_THING.equals(classUri)) continue;
                doc.addField("type", classUri);
                String classGroupUri = clz.getGroupURI();
                if (classGroupUri != null) {
                    classGroupUris.add(classGroupUri);
                }
                if ((boost = clz.getSearchBoost()) == null) continue;
                doc.setDocumentBoost(doc.getDocumentBoost() + boost.floatValue());
            }
            if (!classGroupUris.isEmpty()) {
                doc.addField("classgroup", new Object[]{classGroupUris});
            }
        }

        public String toString() {
            return "Internal: AddClasses";
        }
    }

    private static class IdUriLabel
    extends BaseDocumentModifier {
        private IdUriLabel() {
        }

        @Override
        public void modifyDocument(Individual ind, SearchInputDocument doc) {
            this.addIdAndUri(ind, doc);
            this.addLabel(ind, doc);
        }

        private void addIdAndUri(Individual ind, SearchInputDocument doc) {
            doc.addField("DocId", SearchIndexerUtils.getIdForUri(ind.getURI()));
            doc.addField("URI", ind.getURI());
        }

        private void addLabel(Individual ind, SearchInputDocument doc) {
            String name = ind.getRdfsLabel();
            if (name == null) {
                name = ind.getLocalName();
            }
            doc.addField("nameRaw", name);
            doc.addField("nameLowercaseSingleValued", name);
        }

        public String toString() {
            return "Internal: IdUriLabel";
        }
    }

    private static abstract class BaseDocumentModifier
    implements DocumentModifier {
        private BaseDocumentModifier() {
        }

        protected void addToAlltext(SearchInputDocument doc, String raw) {
            if (StringUtils.isBlank((CharSequence)raw)) {
                return;
            }
            String clean = Jsoup.parse((String)raw).text();
            if (StringUtils.isBlank((CharSequence)clean)) {
                return;
            }
            doc.addField("ALLTEXT", clean);
            doc.addField("ALLTEXTUNSTEMMED", clean);
        }

        @Override
        public void shutdown() {
        }
    }

    public static class MinimalDocumentModifiers {
        private final List<DocumentModifier> list = Arrays.asList(new IdUriLabel(), new AddClasses(), new AddMostSpecificTypes(), new AddObjectPropertyText(), new AddDataPropertyText(), new AddEntityBoost());

        public List<DocumentModifier> getList() {
            return this.list;
        }
    }
}

