/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchIndexExcluderListBasic
implements SearchIndexExcluderList {
    private static final Log log = LogFactory.getLog(SearchIndexExcluderListBasic.class);
    private final List<SearchIndexExcluder> excluders;

    public SearchIndexExcluderListBasic(Collection<? extends SearchIndexExcluder> excluders) {
        this.excluders = Collections.unmodifiableList(new ArrayList<SearchIndexExcluder>(excluders));
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public void stopIndexing() {
    }

    @Override
    public boolean isExcluded(Individual ind) {
        for (SearchIndexExcluder excluder : this.excluders) {
            String message = excluder.checkForExclusion(ind);
            if (message == SearchIndexExcluder.DONT_EXCLUDE) continue;
            log.debug((Object)("Excluded " + ind + " because " + message));
            return true;
        }
        return false;
    }
}

