/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;

public class ThumbnailImageURL
implements DocumentModifier,
ContextModelsUser {
    private static final Log log = LogFactory.getLog(ThumbnailImageURL.class);
    private static final String PREFIX = "prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix bibo: <http://purl.org/ontology/bibo/>  ";
    private static final String QUERY_TEMPLATE = "prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix bibo: <http://purl.org/ontology/bibo/>   SELECT (str(?downloadLocation) as ?DownloadLocation) WHERE {  ?uri <http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage> ?a .  ?a <http://vitro.mannlib.cornell.edu/ns/vitro/public#downloadLocation> ?downloadLocation . } ";
    private volatile RDFService rdf;

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.rdf = models.getRDFService();
    }

    @Override
    public void modifyDocument(Individual individual, SearchInputDocument doc) {
        doc.addField("THUMBNAIL_URL", this.runQueryForThumbnailLocation(individual));
        this.addThumbnailExistence(individual, doc);
    }

    protected void addThumbnailExistence(Individual ind, SearchInputDocument doc) {
        try {
            if (ind.hasThumb()) {
                doc.addField("THUMBNAIL", "1");
            } else {
                doc.addField("THUMBNAIL", "0");
            }
        }
        catch (Exception ex) {
            log.debug((Object)("could not index thumbnail: " + ex));
        }
    }

    protected String runQueryForThumbnailLocation(Individual individual) {
        StringBuilder result = new StringBuilder();
        String uri = "<" + individual.getURI() + "> ";
        String query = QUERY_TEMPLATE.replaceAll("\\?uri", uri);
        try {
            ResultSet results = RDFServiceUtils.sparqlSelectQuery(query, this.rdf);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Iterator iter = soln.varNames();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    RDFNode node = soln.get(name);
                    if (node != null) {
                        result.append("").append(node.toString());
                        continue;
                    }
                    log.info((Object)(name + " is null"));
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        return result.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void shutdown() {
    }
}

