/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.search.controller.IndexController;
import edu.cornell.mannlib.vitro.webapp.search.controller.IndexHistory;
import edu.cornell.mannlib.vitro.webapp.searchindex.IndexingChangeListener;
import edu.cornell.mannlib.vitro.webapp.startup.ComponentStartupStatusImpl;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import edu.cornell.mannlib.vitro.webapp.utils.developer.listeners.DeveloperDisabledChangeListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchIndexerSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(SearchIndexerSetup.class);
    private ServletContext ctx;
    private Application app;
    private SearchIndexer searchIndexer;
    private IndexingChangeListener listener;
    private DeveloperDisabledChangeListener listenerWrapper;
    private IndexHistory history;

    public void contextInitialized(ServletContextEvent sce) {
        this.ctx = sce.getServletContext();
        this.app = ApplicationUtils.instance();
        StartupStatus ss = StartupStatus.getBean(this.ctx);
        try {
            this.searchIndexer = this.app.getSearchIndexer();
            this.listener = new IndexingChangeListener(this.searchIndexer);
            this.listenerWrapper = new DeveloperDisabledChangeListener(this.listener, Key.SEARCH_INDEX_SUPPRESS_MODEL_CHANGE_LISTENER);
            RDFServiceUtils.getRDFServiceFactory(this.ctx).registerJenaModelChangedListener(this.listenerWrapper);
            this.history = new IndexHistory();
            this.searchIndexer.addListener(this.history);
            IndexController.setHistory(this.history);
            this.searchIndexer.startup(this.app, new ComponentStartupStatusImpl(this, ss));
            ss.info(this, "Setup of search indexer completed.");
        }
        catch (RDFServiceException e) {
            ss.fatal(this, "Failed to register the model changed listener.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.searchIndexer.shutdown(this.app);
        this.searchIndexer.removeListener(this.history);
        try {
            RDFServiceUtils.getRDFServiceFactory(this.ctx).unregisterJenaModelChangedListener(this.listenerWrapper);
        }
        catch (RDFServiceException e) {
            log.warn((Object)"Failed to unregister the indexing listener.");
        }
        this.listener.shutdown();
    }
}

