/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchFacetField;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ElasticSearchResultDocumentList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ResponseParser {
    private static final Log log = LogFactory.getLog(ResponseParser.class);
    private final Map<String, Object> responseMap;
    private Map<String, Map<String, List<String>>> highlightingMap;
    private Map<String, SearchFacetField> facetFieldsMap;
    private long totalHits;
    private List<SearchResultDocument> documentList;

    public ResponseParser(String responseString) throws SearchEngineException {
        try {
            this.responseMap = (Map)new ObjectMapper().readValue(responseString, HashMap.class);
        }
        catch (IOException e) {
            throw new SearchEngineException(e);
        }
    }

    public SearchResponse parse() {
        this.parseDocumentList();
        this.parseFacetFields();
        BaseSearchResponse response = new BaseSearchResponse(this.highlightingMap, this.facetFieldsMap, new ElasticSearchResultDocumentList(this.documentList, this.totalHits));
        log.debug((Object)("ESQuery.ResponseParser.parse: " + response));
        return response;
    }

    private void parseFacetFields() {
        this.facetFieldsMap = new HashMap<String, SearchFacetField>();
        Map aggregations = (Map)this.responseMap.get("aggregations");
        if (aggregations == null) {
            return;
        }
        for (String key : aggregations.keySet()) {
            if (!key.startsWith("facet_")) continue;
            String name = key.substring(6);
            this.parseFacetField(name, (Map)aggregations.get(key));
        }
    }

    private void parseFacetField(String name, Map<String, Object> facetMap) {
        List bucketsList = (List)facetMap.get("buckets");
        if (bucketsList == null) {
            return;
        }
        ArrayList<BaseSearchFacetField.BaseCount> counts = new ArrayList<BaseSearchFacetField.BaseCount>();
        for (Map bucket : bucketsList) {
            counts.add(new BaseSearchFacetField.BaseCount((String)bucket.get("key"), ((Integer)bucket.get("doc_count")).intValue()));
        }
        this.facetFieldsMap.put(name, new BaseSearchFacetField(name, counts));
    }

    private void parseDocumentList() {
        this.documentList = new ArrayList<SearchResultDocument>();
        this.highlightingMap = new HashMap<String, Map<String, List<String>>>();
        Map uberHits = (Map)this.responseMap.get("hits");
        if (uberHits == null) {
            log.warn((Object)("Didn't find a 'hits' field in the query response: " + this.responseMap));
            return;
        }
        Integer total = (Integer)uberHits.get("total");
        if (total == null) {
            log.warn((Object)("Didn't find a 'hits.total' field in the query response: " + this.responseMap));
            return;
        }
        List hits = (List)uberHits.get("hits");
        if (hits == null) {
            log.warn((Object)("Didn't find a 'hits.hits' field in the query response: " + this.responseMap));
            return;
        }
        this.parseDocuments(hits);
    }

    private void parseDocuments(List<Map<String, Object>> hits) {
        for (Map<String, Object> hit : hits) {
            SearchResultDocument doc = this.parseDocument(hit);
            if (doc == null) continue;
            this.documentList.add(doc);
            Map<String, List<String>> highlight = this.parseHighlight(hit);
            if (highlight == null) continue;
            this.highlightingMap.put(doc.getUniqueId(), highlight);
        }
    }

    private SearchResultDocument parseDocument(Map<String, Object> hitMap) {
        Map sourceMap = (Map)hitMap.get("_source");
        if (sourceMap == null) {
            log.warn((Object)("Didn't find a '_source' field in the hit: " + hitMap));
            return null;
        }
        String id = (String)hitMap.get("_id");
        if (id == null) {
            log.warn((Object)("Didn't find a '_id' field in the hit: " + hitMap));
            return null;
        }
        return new BaseSearchResultDocument(id, sourceMap);
    }

    private Map<String, List<String>> parseHighlight(Map<String, Object> hitMap) {
        Map highlightMap = (Map)hitMap.get("highlight");
        if (highlightMap == null) {
            log.debug((Object)("Didn't find a 'highlight' field in the hit: " + hitMap));
            return null;
        }
        List snippets = (List)highlightMap.get("ALLTEXT");
        if (snippets == null) {
            log.warn((Object)("Didn't find a 'highlight.ALLTEXT' field in the hit: " + hitMap));
            return null;
        }
        HashMap<String, List<String>> snippetMap = new HashMap<String, List<String>>();
        snippetMap.put("ALLTEXT", snippets);
        return snippetMap;
    }
}

