/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.base;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BaseSearchQuery
implements SearchQuery {
    private String queryText;
    private int start = 0;
    private int rows = -1;
    private final Set<String> fieldsToReturn = new HashSet<String>();
    private final Map<String, SearchQuery.Order> sortFields = new LinkedHashMap<String, SearchQuery.Order>();
    private final Set<String> filters = new HashSet<String>();
    private final Set<String> facetFields = new HashSet<String>();
    private int facetLimit = 100;
    private int facetMinCount = -1;

    @Override
    public SearchQuery setQuery(String query) {
        this.queryText = query;
        return this;
    }

    @Override
    public SearchQuery setStart(int start) {
        this.start = start;
        return this;
    }

    @Override
    public SearchQuery setRows(int rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public SearchQuery addFields(String ... names) {
        return this.addFields(Arrays.asList(names));
    }

    @Override
    public SearchQuery addFields(Collection<String> names) {
        this.fieldsToReturn.addAll(names);
        return this;
    }

    @Override
    public SearchQuery addSortField(String name, SearchQuery.Order order) {
        this.sortFields.put(name, order);
        return this;
    }

    @Override
    public SearchQuery addFilterQuery(String filterQuery) {
        this.filters.add(filterQuery);
        return this;
    }

    @Override
    public SearchQuery addFilterQueries(String ... filterQueries) {
        this.filters.addAll(Arrays.asList(filterQueries));
        return this;
    }

    @Override
    public SearchQuery addFacetFields(String ... fields) {
        this.facetFields.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public SearchQuery setFacetLimit(int cnt) {
        this.facetLimit = cnt;
        return this;
    }

    @Override
    public SearchQuery setFacetMinCount(int cnt) {
        this.facetMinCount = cnt;
        return this;
    }

    @Override
    public String getQuery() {
        return this.queryText;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public Set<String> getFieldsToReturn() {
        return Collections.unmodifiableSet(this.fieldsToReturn);
    }

    @Override
    public Map<String, SearchQuery.Order> getSortFields() {
        return Collections.unmodifiableMap(this.sortFields);
    }

    @Override
    public Set<String> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    @Override
    public Set<String> getFacetFields() {
        return Collections.unmodifiableSet(this.facetFields);
    }

    @Override
    public int getFacetLimit() {
        return this.facetLimit;
    }

    @Override
    public int getFacetMinCount() {
        return this.facetMinCount;
    }

    public String toString() {
        return "BaseSearchQuery[queryText=" + this.queryText + ", start=" + this.start + ", rows=" + this.rows + ", fieldsToReturn=" + this.fieldsToReturn + ", sortFields=" + this.sortFields + ", filters=" + this.filters + ", facetFields=" + this.facetFields + ", facetLimit=" + this.facetLimit + ", facetMinCount=" + this.facetMinCount + "]";
    }
}

