/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.base;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BaseSearchInputField
implements SearchInputField {
    private final String name;
    private final List<Object> valueList;
    private float boost;

    public BaseSearchInputField(String name) {
        this.name = name;
        this.valueList = new ArrayList<Object>();
        this.boost = 1.0f;
    }

    public BaseSearchInputField(SearchInputField field) {
        this.name = field.getName();
        this.valueList = new ArrayList<Object>(field.getValues());
        this.boost = field.getBoost();
    }

    @Override
    public void addValues(Object ... values) {
        this.addValues(Arrays.asList(values));
    }

    @Override
    public void addValues(Collection<? extends Object> values) {
        this.valueList.addAll(values);
    }

    @Override
    public void setBoost(float boost) {
        this.boost = boost;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public Collection<Object> getValues() {
        return new ArrayList<Object>(this.valueList);
    }

    @Override
    public Object getFirstValue() {
        if (this.valueList.isEmpty()) {
            return null;
        }
        return this.valueList.get(0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.boost);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.valueList.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSearchInputField other = (BaseSearchInputField)obj;
        return Float.floatToIntBits(this.boost) == Float.floatToIntBits(other.boost) && this.name.equals(other.name) && this.equalsIgnoreOrder(this.valueList, other.valueList);
    }

    private boolean equalsIgnoreOrder(List<Object> list1, List<Object> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList<Object> remaining = new ArrayList<Object>(list2);
        for (Object value : list1) {
            if (remaining.remove(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "BaseSearchInputField[name=" + this.name + ", valueList=" + this.valueList + ", boost=" + this.boost + "]";
    }
}

