/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.base;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchInputField;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BaseSearchInputDocument
implements SearchInputDocument {
    private final Map<String, SearchInputField> fieldMap;
    private float documentBoost;

    public BaseSearchInputDocument() {
        this.fieldMap = new HashMap<String, SearchInputField>();
        this.documentBoost = 1.0f;
    }

    public BaseSearchInputDocument(BaseSearchInputDocument doc) {
        this.documentBoost = doc.documentBoost;
        this.fieldMap = new HashMap<String, SearchInputField>();
        for (String fieldName : doc.getFieldMap().keySet()) {
            this.fieldMap.put(fieldName, new BaseSearchInputField(doc.getField(fieldName)));
        }
    }

    @Override
    public void addField(SearchInputField field) {
        this.fieldMap.put(field.getName(), field);
    }

    @Override
    public void addField(String name, Object ... values) {
        this.addField(name, 1.0f, Arrays.asList(values));
    }

    @Override
    public void addField(String name, Collection<Object> values) {
        this.addField(name, 1.0f, values);
    }

    @Override
    public void addField(String name, float boost, Object ... values) {
        this.addField(name, boost, Arrays.asList(values));
    }

    @Override
    public void addField(String name, float boost, Collection<Object> values) {
        SearchInputField field = this.fieldMap.get(name);
        if (field == null) {
            field = new BaseSearchInputField(name);
            this.fieldMap.put(name, field);
        }
        field.addValues(values);
        field.setBoost(boost * field.getBoost());
    }

    @Override
    public void setDocumentBoost(float searchBoost) {
        this.documentBoost = searchBoost;
    }

    @Override
    public float getDocumentBoost() {
        return this.documentBoost;
    }

    @Override
    public SearchInputField getField(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public Map<String, SearchInputField> getFieldMap() {
        return new HashMap<String, SearchInputField>(this.fieldMap);
    }

    @Override
    public SearchInputField createField(String name) {
        return new BaseSearchInputField(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.documentBoost);
        result = 31 * result + this.fieldMap.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSearchInputDocument other = (BaseSearchInputDocument)obj;
        return Float.floatToIntBits(this.documentBoost) == Float.floatToIntBits(other.documentBoost) && this.fieldMap.equals(other.fieldMap);
    }

    public String toString() {
        return "BaseSearchInputDocument[fieldMap=" + this.fieldMap + ", documentBoost=" + this.documentBoost + "]";
    }
}

