/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner.plugin;

import edu.cornell.mannlib.vitro.webapp.reasoner.ReasonerPlugin;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class SimplePropertyAndTypeRule
implements ReasonerPlugin {
    private Property ASSERTED_PROP;
    private Resource TYPE;
    private Property INFERRED_PROP;
    private SimpleReasoner simpleReasoner;

    protected SimplePropertyAndTypeRule(String assertedProp, String type, String inferredProp) {
        this.TYPE = ResourceFactory.createResource((String)type);
        this.ASSERTED_PROP = ResourceFactory.createProperty((String)assertedProp);
        this.INFERRED_PROP = ResourceFactory.createProperty((String)inferredProp);
    }

    @Override
    public boolean isConfigurationOnlyPlugin() {
        return false;
    }

    @Override
    public boolean isInterestedInAddedStatement(Statement stmt) {
        return RDF.type.equals(stmt.getPredicate()) || this.isRelevantPredicate(stmt);
    }

    @Override
    public boolean isInterestedInRemovedStatement(Statement stmt) {
        return RDF.type.equals(stmt.getPredicate()) || this.isRelevantPredicate(stmt);
    }

    @Override
    public void addedABoxStatement(Statement stmt, Model aboxAssertionsModel, Model aboxInferencesModel, OntModel TBoxInferencesModel) {
        boolean relevantType = this.isRelevantType(stmt, (Model)TBoxInferencesModel);
        boolean relevantPredicate = this.isRelevantPredicate(stmt);
        if (relevantType) {
            StmtIterator stmtIt = aboxAssertionsModel.listStatements(stmt.getSubject(), this.ASSERTED_PROP, (RDFNode)null);
            while (stmtIt.hasNext()) {
                Statement s = stmtIt.nextStatement();
                this.tryToInfer(stmt.getSubject(), this.INFERRED_PROP, s.getObject(), aboxAssertionsModel, aboxInferencesModel);
            }
        } else if (relevantPredicate && (aboxAssertionsModel.contains(stmt.getSubject(), RDF.type, (RDFNode)this.TYPE) || aboxInferencesModel.contains(stmt.getSubject(), RDF.type, (RDFNode)this.TYPE))) {
            this.tryToInfer(stmt.getSubject(), this.INFERRED_PROP, stmt.getObject(), aboxAssertionsModel, aboxInferencesModel);
        }
    }

    private void tryToInfer(Resource subject, Property predicate, RDFNode object, Model aboxAssertionsModel, Model aboxInferencesModel) {
        Statement s = ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object);
        if (this.simpleReasoner != null) {
            this.simpleReasoner.addInference(s, aboxInferencesModel);
        }
    }

    @Override
    public void removedABoxStatement(Statement stmt, Model aboxAssertionsModel, Model aboxInferencesModel, OntModel TBoxInferencesModel) {
        if (this.isRelevantPredicate(stmt)) {
            if (this.simpleReasoner != null) {
                this.simpleReasoner.removeInference(ResourceFactory.createStatement((Resource)stmt.getSubject(), (Property)this.INFERRED_PROP, (RDFNode)stmt.getObject()), aboxInferencesModel);
            }
        } else if (this.isRelevantType(stmt, (Model)TBoxInferencesModel) && !aboxInferencesModel.contains(stmt.getSubject(), RDF.type, (RDFNode)this.TYPE)) {
            StmtIterator groundIt = aboxAssertionsModel.listStatements(stmt.getSubject(), this.ASSERTED_PROP, (RDFNode)null);
            while (groundIt.hasNext()) {
                Statement groundStmt = groundIt.nextStatement();
                this.simpleReasoner.removeInference(ResourceFactory.createStatement((Resource)groundStmt.getSubject(), (Property)this.INFERRED_PROP, (RDFNode)groundStmt.getObject()), aboxInferencesModel);
            }
        }
    }

    private boolean isRelevantType(Statement stmt, Model TBoxInferencesModel) {
        return RDF.type.equals(stmt.getPredicate()) && (this.TYPE.equals((Object)stmt.getObject()) || TBoxInferencesModel.contains((Resource)stmt.getObject(), RDFS.subClassOf, (RDFNode)this.TYPE));
    }

    private boolean isRelevantPredicate(Statement stmt) {
        return this.ASSERTED_PROP.equals(stmt.getPredicate());
    }

    @Override
    public void setSimpleReasoner(SimpleReasoner simpleReasoner) {
        this.simpleReasoner = simpleReasoner;
    }

    @Override
    public SimpleReasoner getSimpleReasoner() {
        return this.simpleReasoner;
    }
}

