/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LangSort {
    private static final Log log = LogFactory.getLog(LangSort.class);
    protected List<String> langs;
    private int inexactMatchPenalty;
    private int noLanguage;
    private int noMatch;

    public LangSort(List<String> preferredLanguageStrings) {
        this.langs = preferredLanguageStrings;
        this.inexactMatchPenalty = this.langs.size();
        this.noLanguage = 2 * this.inexactMatchPenalty;
        this.noMatch = this.noLanguage + 1;
    }

    protected int compareLangs(String t1lang, String t2lang) {
        int index2;
        int index1 = this.languageIndex(t1lang);
        if (index1 == (index2 = this.languageIndex(t2lang))) {
            return t1lang.compareTo(t2lang);
        }
        return this.languageIndex(t1lang) - this.languageIndex(t2lang);
    }

    private int languageIndex(String lang) {
        int index;
        if (lang == null) {
            lang = "";
        }
        if ((index = this.langs.indexOf(lang)) >= 0) {
            log.debug((Object)("languageIndex for '" + lang + "' is " + index));
            return index;
        }
        if (lang.length() > 2 && (index = this.langs.indexOf(lang.substring(0, 2))) >= 0) {
            log.debug((Object)("languageIndex for '" + lang + "' is " + index + this.inexactMatchPenalty));
            return index + this.inexactMatchPenalty;
        }
        if (lang.isEmpty()) {
            log.debug((Object)("languageIndex for '" + lang + "' is " + this.noLanguage));
            return this.noLanguage;
        }
        return this.noMatch;
    }
}

