/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdater;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.rdf.model.Model;

public class RDFServiceBulkUpdater
extends AbstractBulkUpdater {
    RDFServiceGraph graph;
    private static final int chunkSize = 50000;
    private static final String REMOVE_CHUNK_QUERY = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o } LIMIT 50000";

    public RDFServiceBulkUpdater(RDFServiceGraph graph) {
        this.graph = graph;
    }

    @Override
    protected void performAddModel(Model model) {
        ChangeSet changeSet = this.graph.getRDFService().manufactureChangeSet();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.write((OutputStream)out, "N-TRIPLE");
        changeSet.addAddition(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, this.graph.getGraphURI());
        try {
            this.graph.getRDFService().changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    @Override
    protected void performRemoveModel(Model model) {
        ChangeSet changeSet = this.graph.getRDFService().manufactureChangeSet();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.write((OutputStream)out, "N-TRIPLE");
        changeSet.addRemoval(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, this.graph.getGraphURI());
        try {
            this.graph.getRDFService().changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    @Override
    protected void performRemoveAll() {
        String graphURI = this.graph.getGraphURI();
        String queryString = graphURI != null ? RDFServiceBulkUpdater.getRemoveGraphChunkPattern(graphURI) : REMOVE_CHUNK_QUERY;
        while (!this.graph.isEmpty()) {
            try {
                InputStream chunkToRemove = this.graph.getRDFService().sparqlConstructQuery(queryString, RDFService.ModelSerializationFormat.N3);
                ChangeSet cs = this.graph.getRDFService().manufactureChangeSet();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                cs.addRemoval(chunkToRemove, RDFService.ModelSerializationFormat.N3, graphURI);
                this.graph.getRDFService().changeSetUpdate(cs);
            }
            catch (RDFServiceException e) {
                throw new RuntimeException(e);
            }
        }
        this.graph.getEventManager().notifyEvent((Graph)this.graph, (Object)GraphEvents.removeAll);
    }

    private static String getRemoveGraphChunkPattern(String uri) {
        return "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH <" + uri + "> {?s ?p ?o } } LIMIT " + 50000;
    }
}

