/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkGraphMem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ExtendedIterator;

public final class GraphUtils {
    private static final int CMP_GREATER = 1;
    private static final int CMP_EQUAL = 0;
    private static final int CMP_LESS = -1;
    private static int MIN_SRC_SIZE = 1000;
    private static int DST_SRC_RATIO = 2;

    public static Graph unwrapUnionGraphs(Graph graph) {
        if (graph != null && graph instanceof MultiUnion) {
            return GraphUtils.unwrapUnionGraphs(((MultiUnion)graph).getBaseGraph());
        }
        return graph;
    }

    public static void deleteFrom(BulkGraphMem bulkGraphMem, Graph srcGraph) {
        boolean events = bulkGraphMem.getEventManager().listening();
        if (bulkGraphMem == srcGraph && !events) {
            bulkGraphMem.clear();
            return;
        }
        boolean loopOnSrc = GraphUtils.decideHowtoExecuteBySizeStep(bulkGraphMem, srcGraph);
        if (loopOnSrc) {
            GraphUtils.deleteLoopSrc(bulkGraphMem, srcGraph);
            return;
        }
        GraphUtils.deleteLoopDst(bulkGraphMem, srcGraph);
    }

    public static void addInto(BulkGraphMem bulkGraphMem, Graph srcGraph) {
        if (bulkGraphMem == srcGraph && !bulkGraphMem.getEventManager().listening()) {
            return;
        }
        bulkGraphMem.getPrefixMapping().setNsPrefixes(srcGraph.getPrefixMapping());
        GraphUtils.addIteratorWorker(bulkGraphMem, GraphUtils.findAll(srcGraph));
        bulkGraphMem.getEventManager().notifyAddGraph((Graph)bulkGraphMem, srcGraph);
    }

    private static ExtendedIterator<Triple> findAll(Graph g) {
        return g.find();
    }

    private static void addIteratorWorker(BulkGraphMem bulkGraphMem, Iterator<Triple> it) {
        List s = IteratorCollection.iteratorToList(it);
        GraphUtils.addIteratorWorkerDirect(bulkGraphMem, s.iterator());
    }

    private static void addIteratorWorkerDirect(BulkGraphMem bulkGraphMem, Iterator<Triple> it) {
        it.forEachRemaining(bulkGraphMem::addWithoutNotify);
    }

    private static void deleteLoopSrc(BulkGraphMem bulkGraphMem, Graph srcGraph) {
        GraphUtils.deleteIteratorWorker(bulkGraphMem, GraphUtils.findAll(srcGraph));
        bulkGraphMem.getEventManager().notifyDeleteGraph((Graph)bulkGraphMem, srcGraph);
    }

    private static void deleteLoopDst(BulkGraphMem bulkGraphMem, Graph srcGraph) {
        int dstSize = bulkGraphMem.size();
        ArrayList<Triple> toBeDeleted = new ArrayList<Triple>(dstSize);
        ExtendedIterator<Triple> iter = GraphUtils.findAll((Graph)bulkGraphMem);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (!srcGraph.contains(t)) continue;
            toBeDeleted.add(t);
        }
        GraphUtils.deleteIteratorWorkerDirect(bulkGraphMem, toBeDeleted.iterator());
        bulkGraphMem.getEventManager().notifyDeleteGraph((Graph)bulkGraphMem, srcGraph);
    }

    private static void deleteIteratorWorker(BulkGraphMem bulkGraphMem, Iterator<Triple> it) {
        List s = IteratorCollection.iteratorToList(it);
        GraphUtils.deleteIteratorWorkerDirect(bulkGraphMem, s.iterator());
    }

    private static void deleteIteratorWorkerDirect(BulkGraphMem bulkGraphMem, Iterator<Triple> it) {
        it.forEachRemaining(bulkGraphMem::deleteWithoutNotify);
    }

    private static boolean decideHowtoExecuteBySizeStep(BulkGraphMem bulkGraphMem, Graph srcGraph) {
        int srcSize = srcGraph.size();
        if (srcSize <= MIN_SRC_SIZE) {
            return true;
        }
        boolean loopOnSrc = srcSize <= MIN_SRC_SIZE || GraphUtils.compareSizeTo((Graph)bulkGraphMem, DST_SRC_RATIO * srcSize) == 1;
        return loopOnSrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int compareSizeTo(Graph graph, int size) {
        try (ExtendedIterator it = graph.find();){
            int stepsTake = Iter.step((Iterator)it, (int)size);
            if (stepsTake < size) {
                int n = -1;
                return n;
            }
            if (!it.hasNext()) {
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
    }
}

