/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkGraphMem;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.GraphUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.impl.OntModelImpl;
import org.apache.jena.rdf.model.Model;

public class BulkOntModelImpl
extends OntModelImpl {
    public BulkOntModelImpl(OntModelSpec spec) {
        super(spec);
    }

    public BulkOntModelImpl(OntModelSpec owlMem, Model bareModel) {
        super(owlMem, bareModel);
    }

    public Model remove(Model m) {
        Graph unwrappedGraph = GraphUtils.unwrapUnionGraphs(this.graph);
        if (unwrappedGraph instanceof BulkGraphMem) {
            GraphUtils.deleteFrom((BulkGraphMem)unwrappedGraph, m.getGraph());
        } else {
            super.remove(m);
        }
        return this;
    }

    public Model add(Model m) {
        Graph unwrappedGraph = GraphUtils.unwrapUnionGraphs(this.graph);
        if (unwrappedGraph instanceof BulkGraphMem) {
            GraphUtils.addInto((BulkGraphMem)unwrappedGraph, m.getGraph());
        } else {
            super.add(m);
        }
        return this;
    }
}

