/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleChangeLogger
implements ChangeLogger {
    private Writer logWriter;
    private Writer errorWriter;
    private boolean errorsWritten = false;

    public SimpleChangeLogger(String logPath, String errorPath) {
        File logFile = new File(logPath);
        File errorFile = new File(errorPath);
        try {
            this.logWriter = new BufferedWriter(new FileWriter(logFile));
            this.errorWriter = new BufferedWriter(new FileWriter(errorFile));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to open ontology change log files for writing", ioe);
        }
    }

    @Override
    public void log(String logMessage) throws IOException {
        Exception e = new Exception();
        StackTraceElement[] elements = e.getStackTrace();
        String className = elements[1].getClassName();
        className = className.substring(className.lastIndexOf(46) + 1);
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        this.logWriter.write(formatter.format(now) + " " + className + ":  " + logMessage + "\n\n");
        this.logWriter.flush();
    }

    @Override
    public void logWithDate(String logMessage) throws IOException {
        Exception e = new Exception();
        StackTraceElement[] elements = e.getStackTrace();
        String className = elements[1].getClassName();
        className = className.substring(className.lastIndexOf(46) + 1);
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy hh:mm a z");
        this.logWriter.write(formatter.format(now) + " " + className + ":  " + logMessage + "\n\n");
        this.logWriter.flush();
    }

    @Override
    public void logError(String errorMessage) throws IOException {
        this.errorsWritten = true;
        Exception e = new Exception();
        StackTraceElement[] elements = e.getStackTrace();
        String className = elements[1].getClassName();
        className = className.substring(className.lastIndexOf(46) + 1);
        String methodName = elements[1].getMethodName();
        int lineNumber = elements[1].getLineNumber();
        this.errorWriter.write(className + "." + methodName + " line " + lineNumber + ":  " + errorMessage + "\n");
        this.errorWriter.flush();
    }

    @Override
    public void closeLogs() throws IOException {
        this.logWriter.flush();
        this.logWriter.close();
        this.errorWriter.flush();
        this.errorWriter.close();
    }

    @Override
    public boolean errorsWritten() {
        return this.errorsWritten;
    }
}

