/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modules.searchIndexer;

import java.text.SimpleDateFormat;
import java.util.Date;

public class SearchIndexerStatus {
    private final State state;
    private final Date since;
    private final Counts counts;

    public static SearchIndexerStatus idle() {
        return new SearchIndexerStatus(State.IDLE, new Date(), new NoCounts());
    }

    public static SearchIndexerStatus shutdown() {
        return new SearchIndexerStatus(State.SHUTDOWN, new Date(), new NoCounts());
    }

    public SearchIndexerStatus(State state, Date since, Counts counts) {
        this.state = state;
        this.since = since;
        this.counts = counts;
    }

    public State getState() {
        return this.state;
    }

    public Date getSince() {
        return this.since;
    }

    public Counts getCounts() {
        return this.counts;
    }

    public String toString() {
        return new SimpleDateFormat().format(this.since) + ", " + this.counts;
    }

    public static class NoCounts
    extends Counts {
        public NoCounts() {
            super(Counts.Type.NO_COUNTS);
        }

        public String toString() {
            return "[]";
        }
    }

    public static class RebuildCounts
    extends Counts {
        private final int documentsBefore;
        private final int documentsAfter;

        public RebuildCounts(int documentsBefore, int documentsAfter) {
            super(Counts.Type.REBUILD_COUNTS);
            this.documentsBefore = documentsBefore;
            this.documentsAfter = documentsAfter;
        }

        public int getDocumentsBefore() {
            return this.documentsBefore;
        }

        public int getDocumentsAfter() {
            return this.documentsAfter;
        }

        public String toString() {
            return "[documentsBefore=" + this.documentsBefore + ", documentsAfter=" + this.documentsAfter + "]";
        }
    }

    public static class StatementCounts
    extends Counts {
        private final int processed;
        private final int remaining;
        private final int total;

        public StatementCounts(int processed, int remaining, int total) {
            super(Counts.Type.STATEMENT_COUNTS);
            this.processed = processed;
            this.remaining = remaining;
            this.total = total;
        }

        public int getProcessed() {
            return this.processed;
        }

        public int getRemaining() {
            return this.remaining;
        }

        public int getTotal() {
            return this.total;
        }

        public String toString() {
            return "[processed=" + this.processed + ", remaining=" + this.remaining + ", total=" + this.total + "]";
        }
    }

    public static class UriCounts
    extends Counts {
        private final int excluded;
        private final int deleted;
        private final int updated;
        private final int remaining;
        private final int total;

        public UriCounts(int excluded, int deleted, int updated, int remaining, int total) {
            super(Counts.Type.URI_COUNTS);
            this.excluded = excluded;
            this.deleted = deleted;
            this.updated = updated;
            this.remaining = remaining;
            this.total = total;
        }

        public int getExcluded() {
            return this.excluded;
        }

        public int getDeleted() {
            return this.deleted;
        }

        public int getUpdated() {
            return this.updated;
        }

        public int getRemaining() {
            return this.remaining;
        }

        public int getTotal() {
            return this.total;
        }

        public String toString() {
            return "[excluded=" + this.excluded + ", deleted=" + this.deleted + ", updated=" + this.updated + ", remaining=" + this.remaining + ", total=" + this.total + "]";
        }
    }

    public static abstract class Counts {
        private final Type type;

        public Counts(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public UriCounts asUriCounts() {
            return (UriCounts)this;
        }

        public StatementCounts asStatementCounts() {
            return (StatementCounts)this;
        }

        public RebuildCounts asRebuildCounts() {
            return (RebuildCounts)this;
        }

        public NoCounts asNoCounts() {
            return (NoCounts)this;
        }

        public static enum Type {
            URI_COUNTS,
            STATEMENT_COUNTS,
            REBUILD_COUNTS,
            NO_COUNTS;

        }
    }

    public static enum State {
        IDLE,
        PROCESSING_URIS,
        PROCESSING_STMTS,
        REBUILDING,
        SHUTDOWN;

    }
}

