/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modules.imageProcessor;

import edu.cornell.mannlib.vitro.webapp.modules.Application;
import java.io.IOException;
import java.io.InputStream;

public interface ImageProcessor
extends Application.Module {
    public static final int MINIMUM_CROP_SIZE = 5;

    public Dimensions getDimensions(InputStream var1) throws ImageProcessorException, IOException;

    public InputStream cropAndScale(InputStream var1, CropRectangle var2, Dimensions var3) throws ImageProcessorException, IOException;

    public static class CropRectangle {
        public final int x;
        public final int y;
        public final int height;
        public final int width;

        public CropRectangle(int x, int y, int height, int width) {
            this.x = x;
            this.y = y;
            this.height = height;
            this.width = width;
        }

        public String toString() {
            return "CropRectangle[x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height + "]";
        }
    }

    public static class Dimensions {
        public final int width;
        public final int height;

        public Dimensions(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return "ImageProcessor.Dimensions[width=" + this.width + ", height=" + this.height + "]";
        }
    }

    public static class ImageProcessorException
    extends Exception {
        public ImageProcessorException(String message) {
            super(message);
        }

        public ImageProcessorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

