/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.jena.ontology.OntModel;

public class UnionModelsOntModelsCache
implements OntModelCache {
    private final OntModelCache inner;
    private final Map<String, UnionSpec> unionModelsMap;

    public UnionModelsOntModelsCache(OntModelCache inner, UnionSpec ... unionModelSpecs) {
        this.inner = inner;
        this.unionModelsMap = new HashMap<String, UnionSpec>();
        for (UnionSpec spec : unionModelSpecs) {
            String unionUri = spec.getUnionUri();
            if (this.unionModelsMap.containsKey(unionUri)) {
                throw new IllegalArgumentException("Two UnionSpecs may not have the same union URI: " + spec + ", " + this.unionModelsMap.get(unionUri));
            }
            this.unionModelsMap.put(unionUri, spec);
        }
        for (UnionSpec spec : this.unionModelsMap.values()) {
            if (!this.unionModelsMap.containsKey(spec.getBaseUri()) && !this.unionModelsMap.containsKey(spec.getPlusUri())) continue;
            throw new IllegalArgumentException("A UnionSpec may not build on another UnionSpec: " + spec);
        }
    }

    private boolean hasUnionModel(String name) {
        return this.unionModelsMap.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OntModel getUnionModel(String name) {
        UnionSpec spec;
        UnionSpec unionSpec = spec = this.unionModelsMap.get(name);
        synchronized (unionSpec) {
            if (spec.getUnionModel() == null) {
                OntModel baseModel = this.inner.getOntModel(spec.getBaseUri());
                OntModel plusModel = this.inner.getOntModel(spec.getPlusUri());
                spec.setUnionModel(VitroModelFactory.createUnion(baseModel, plusModel));
            }
        }
        return spec.getUnionModel();
    }

    @Override
    public OntModel getOntModel(String name) {
        if (this.hasUnionModel(name)) {
            return this.getUnionModel(name);
        }
        return this.inner.getOntModel(name);
    }

    @Override
    public SortedSet<String> getModelNames() {
        TreeSet<String> names = new TreeSet<String>(this.inner.getModelNames());
        names.addAll(this.unionModelsMap.keySet());
        return names;
    }

    public String toString() {
        return "UnionModelsOntModelsCache[" + ToString.hashHex(this) + ", inner=" + this.inner + ", unionModelsMap=" + this.unionModelsMap + "]";
    }

    public static class UnionSpecPair {
        private final String baseUri;
        private final String plusUri;

        public UnionSpecPair(String baseUri, String plusUri) {
            this.baseUri = baseUri;
            this.plusUri = plusUri;
        }

        public UnionSpec yields(String unionUri) {
            return new UnionSpec(this.baseUri, this.plusUri, unionUri);
        }
    }

    public static class UnionSpecBase {
        private final String baseUri;

        UnionSpecBase(String baseUri) {
            this.baseUri = baseUri;
        }

        public UnionSpecPair plus(String plusUri) {
            return new UnionSpecPair(this.baseUri, plusUri);
        }
    }

    public static class UnionSpec {
        private final String baseUri;
        private final String plusUri;
        private final String unionUri;
        private OntModel unionModel;

        public static UnionSpecBase base(String baseUri) {
            return new UnionSpecBase(baseUri);
        }

        public UnionSpec(String baseUri, String plusUri, String unionUri) {
            this.baseUri = baseUri;
            this.plusUri = plusUri;
            this.unionUri = unionUri;
        }

        public OntModel getUnionModel() {
            return this.unionModel;
        }

        public void setUnionModel(OntModel unionModel) {
            this.unionModel = unionModel;
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public String getPlusUri() {
            return this.plusUri;
        }

        public String getUnionUri() {
            return this.unionUri;
        }

        public String toString() {
            return "UnionSpec[baseUri=" + this.baseUri + ", plusUri=" + this.plusUri + ", unionUri=" + this.unionUri + "]";
        }
    }
}

