/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.ModelAccessKey;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.OntModelKey;

public final class OntModelSelectorKey
extends ModelAccessKey {
    public OntModelSelectorKey(ModelAccess.OntModelSelectorOption ... options) {
        super(OntModelSelectorKey.findLanguageOption(options), OntModelSelectorKey.findReasoningOption(options));
    }

    @Override
    public ModelAccess.LanguageOption getLanguageOption() {
        return super.getLanguageOption();
    }

    @Override
    public ModelAccess.ReasoningOption getReasoningOption() {
        return super.getReasoningOption();
    }

    public OntModelKey aboxKey() {
        switch (this.getReasoningOption()) {
            case ASSERTIONS_ONLY: {
                return new OntModelKey("http://vitro.mannlib.cornell.edu/default/vitro-kb-2", this.getLanguageOption());
            }
            case INFERENCES_ONLY: {
                return new OntModelKey("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf", this.getLanguageOption());
            }
        }
        return new OntModelKey("vitro:aboxOntModel", this.getLanguageOption());
    }

    public OntModelKey tboxKey() {
        switch (this.getReasoningOption()) {
            case ASSERTIONS_ONLY: {
                return new OntModelKey("http://vitro.mannlib.cornell.edu/default/asserted-tbox", this.getLanguageOption());
            }
            case INFERENCES_ONLY: {
                return new OntModelKey("http://vitro.mannlib.cornell.edu/default/inferred-tbox", this.getLanguageOption());
            }
        }
        return new OntModelKey("vitro:tboxOntModel", this.getLanguageOption());
    }

    public OntModelKey fullKey() {
        switch (this.getReasoningOption()) {
            case ASSERTIONS_ONLY: {
                return new OntModelKey("vitro:baseOntModel", this.getLanguageOption());
            }
            case INFERENCES_ONLY: {
                return new OntModelKey("vitro:inferenceOntModel", this.getLanguageOption());
            }
        }
        return new OntModelKey("vitro:jenaOntModel", this.getLanguageOption());
    }

    public OntModelKey ontModelKey(String name) {
        return new OntModelKey(name, this.getLanguageOption());
    }
}

