/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ModelAccessKey {
    protected final List<ModelAccess.ModelAccessOption> keyComponents;
    private final int hashCode;

    protected static ModelAccess.WhichService findWhichService(ModelAccess.ModelAccessOption ... options) {
        return ModelAccessKey.findWhichService(Arrays.asList(options));
    }

    protected static ModelAccess.WhichService findWhichService(Iterable<ModelAccess.ModelAccessOption> options) {
        return ModelAccessKey.findOption(options, ModelAccess.WhichService.CONTENT, ModelAccess.WhichService.class);
    }

    protected static ModelAccess.ReasoningOption findReasoningOption(ModelAccess.ModelAccessOption ... options) {
        return ModelAccessKey.findReasoningOption(Arrays.asList(options));
    }

    protected static ModelAccess.ReasoningOption findReasoningOption(Iterable<ModelAccess.ModelAccessOption> options) {
        return ModelAccessKey.findOption(options, ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES, ModelAccess.ReasoningOption.class);
    }

    protected static ModelAccess.LanguageOption findLanguageOption(ModelAccess.ModelAccessOption ... options) {
        return ModelAccessKey.findLanguageOption(Arrays.asList(options));
    }

    protected static ModelAccess.LanguageOption findLanguageOption(Iterable<ModelAccess.ModelAccessOption> options) {
        return ModelAccessKey.findOption(options, ModelAccess.LanguageOption.LANGUAGE_AWARE, ModelAccess.LanguageOption.class);
    }

    protected static ModelAccess.PolicyOption findPolicyOption(ModelAccess.ModelAccessOption[] options) {
        return ModelAccessKey.findPolicyOption(Arrays.asList(options));
    }

    protected static ModelAccess.PolicyOption findPolicyOption(Iterable<ModelAccess.ModelAccessOption> options) {
        return ModelAccessKey.findOption(options, ModelAccess.PolicyOption.POLICY_AWARE, ModelAccess.PolicyOption.class);
    }

    private static <T> T findOption(Iterable<ModelAccess.ModelAccessOption> options, T defaultValue, Class<T> clazz) {
        T found = null;
        for (ModelAccess.ModelAccessOption option : options) {
            if (found == option || !clazz.isInstance(option)) continue;
            if (found == null) {
                found = clazz.cast(option);
                continue;
            }
            throw new IllegalArgumentException("Conflicting options: " + found + " and " + option);
        }
        if (found == null) {
            return defaultValue;
        }
        return found;
    }

    protected ModelAccessKey(ModelAccess.ModelAccessOption ... options) {
        this.keyComponents = Collections.unmodifiableList(new ArrayList<ModelAccess.ModelAccessOption>(Arrays.asList(options)));
        this.hashCode = this.keyComponents.hashCode() ^ this.getClass().hashCode();
    }

    protected ModelAccess.ReasoningOption getReasoningOption() {
        return ModelAccessKey.findReasoningOption(this.keyComponents);
    }

    protected ModelAccess.LanguageOption getLanguageOption() {
        return ModelAccessKey.findLanguageOption(this.keyComponents);
    }

    protected ModelAccess.WhichService getWhichService() {
        return ModelAccessKey.findWhichService(this.keyComponents);
    }

    protected ModelAccess.PolicyOption getPolicyOption() {
        return ModelAccessKey.findPolicyOption(this.keyComponents);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelAccessKey that = (ModelAccessKey)obj;
        return this.keyComponents.equals(that.keyComponents);
    }

    public String toString() {
        ArrayList<ModelAccess.ModelAccessOption> notDefaults = new ArrayList<ModelAccess.ModelAccessOption>();
        for (ModelAccess.ModelAccessOption option : this.keyComponents) {
            if (option.isDefault()) continue;
            notDefaults.add(option);
        }
        return this.getClass().getSimpleName() + notDefaults;
    }
}

