/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.RequestModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.ContextModelAccessImpl;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.RequestModelAccessImpl;
import edu.cornell.mannlib.vitro.webapp.triplesource.CombinedTripleSource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelAccess {
    private static final Log log = LogFactory.getLog(ModelAccess.class);
    public static final LanguageOption LANGUAGE_NEUTRAL = LanguageOption.LANGUAGE_NEUTRAL;
    public static final LanguageOption LANGUAGE_AWARE = LanguageOption.LANGUAGE_AWARE;
    public static final ReasoningOption ASSERTIONS_ONLY = ReasoningOption.ASSERTIONS_ONLY;
    public static final ReasoningOption INFERENCES_ONLY = ReasoningOption.INFERENCES_ONLY;
    public static final ReasoningOption ASSERTIONS_AND_INFERENCES = ReasoningOption.ASSERTIONS_AND_INFERENCES;
    public static final PolicyOption POLICY_NEUTRAL = PolicyOption.POLICY_NEUTRAL;
    public static final PolicyOption POLICY_AWARE = PolicyOption.POLICY_AWARE;
    public static final WhichService CONTENT = WhichService.CONTENT;
    public static final WhichService CONFIGURATION = WhichService.CONFIGURATION;
    private static volatile CombinedTripleSource combinedTripleSource;
    private static volatile ModelAccessFactory factory;
    private static final String ATTRIBUTE_NAME;

    public static void setCombinedTripleSource(CombinedTripleSource source) {
        if (combinedTripleSource != null) {
            log.warn((Object)("Assigning CombinedTripleSource " + source + ", but was already set to " + combinedTripleSource));
        }
        combinedTripleSource = source;
    }

    public static RequestModelAccess on(HttpServletRequest req) {
        Object o = req.getAttribute(ATTRIBUTE_NAME);
        if (o instanceof RequestModelAccess) {
            return (RequestModelAccess)o;
        }
        RequestModelAccess access = factory.buildRequestModelAccess(req);
        req.setAttribute(ATTRIBUTE_NAME, (Object)access);
        return access;
    }

    public static boolean isPresent(HttpServletRequest req) {
        return req.getAttribute(ATTRIBUTE_NAME) instanceof RequestModelAccess;
    }

    public static ContextModelAccess on(ServletContext ctx) {
        Object o = ctx.getAttribute(ATTRIBUTE_NAME);
        if (o instanceof ContextModelAccess) {
            return (ContextModelAccess)o;
        }
        ContextModelAccess access = factory.buildContextModelAccess(ctx);
        ctx.setAttribute(ATTRIBUTE_NAME, (Object)access);
        return access;
    }

    static {
        factory = new ModelAccessFactory();
        ATTRIBUTE_NAME = ModelAccess.class.getName();
    }

    public static class ModelAccessFactory {
        public ContextModelAccess buildContextModelAccess(ServletContext ctx) {
            return new ContextModelAccessImpl(ctx, combinedTripleSource);
        }

        public RequestModelAccess buildRequestModelAccess(HttpServletRequest req) {
            return new RequestModelAccessImpl(req, combinedTripleSource.getShortTermCombinedTripleSource(req));
        }
    }

    public static enum WhichService implements RdfServiceOption,
    DatasetOption
    {
        CONTENT,
        CONFIGURATION;


        @Override
        public boolean isDefault() {
            return this == CONTENT;
        }
    }

    public static enum PolicyOption implements WebappDaoFactoryOption
    {
        POLICY_NEUTRAL,
        POLICY_AWARE;


        @Override
        public boolean isDefault() {
            return this == POLICY_AWARE;
        }
    }

    public static enum ReasoningOption implements OntModelSelectorOption,
    WebappDaoFactoryOption
    {
        ASSERTIONS_ONLY,
        INFERENCES_ONLY,
        ASSERTIONS_AND_INFERENCES;


        @Override
        public boolean isDefault() {
            return this == ASSERTIONS_AND_INFERENCES;
        }
    }

    public static enum LanguageOption implements RdfServiceOption,
    DatasetOption,
    OntModelSelectorOption,
    WebappDaoFactoryOption
    {
        LANGUAGE_NEUTRAL,
        LANGUAGE_AWARE;


        @Override
        public boolean isDefault() {
            return this == LANGUAGE_AWARE;
        }
    }

    public static interface WebappDaoFactoryOption
    extends ModelAccessOption {
    }

    public static interface OntModelSelectorOption
    extends ModelAccessOption {
    }

    public static interface DatasetOption
    extends ModelAccessOption {
    }

    public static interface RdfServiceOption
    extends ModelAccessOption {
    }

    public static interface ModelAccessOption {
        public boolean isDefault();
    }
}

