/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleSelectionDataGetter
implements DataGetter {
    private static final Log log = LogFactory.getLog(LocaleSelectionDataGetter.class);
    private final VitroRequest vreq;
    private static final char PRIVATE_USE_SUBTAG = 'x';

    public LocaleSelectionDataGetter(VitroRequest vreq) {
        this.vreq = vreq;
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> valueMap) {
        List<Locale> selectables = SelectedLocale.getSelectableLocales((HttpServletRequest)this.vreq);
        if (selectables.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("selectLocaleUrl", UrlBuilder.getUrl("/selectLocale"));
        result.put("locales", this.buildLocalesList(selectables));
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("selectLocale", result);
        log.debug((Object)("Sending these values: " + bodyMap));
        return bodyMap;
    }

    private List<Map<String, Object>> buildLocalesList(List<Locale> selectables) {
        Locale currentLocale = SelectedLocale.getCurrentLocale((HttpServletRequest)this.vreq);
        boolean includeAbbreviation = false;
        HashSet<String> setOfLocalesBase = new HashSet<String>();
        for (Locale locale : selectables) {
            setOfLocalesBase.add(locale.stripExtensions().toLanguageTag());
        }
        if (setOfLocalesBase.size() < selectables.size()) {
            includeAbbreviation = true;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Locale locale : selectables) {
            try {
                list.add(this.buildLocaleMap(locale, currentLocale, includeAbbreviation));
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Can't show the Locale selector for '" + locale + "': " + e));
            }
        }
        return list;
    }

    private Map<String, Object> buildLocaleMap(Locale locale, Locale currentLocale, boolean includeAbbreviation) throws FileNotFoundException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", locale.toLanguageTag().replace('-', '_'));
        map.put("label", locale.getDisplayLanguage(locale));
        map.put("country", locale.getDisplayCountry(locale));
        if (includeAbbreviation) {
            map.put("institution", Optional.ofNullable(locale.getExtension('x')).orElse("").toUpperCase());
        }
        map.put("selected", currentLocale.equals(locale));
        return map;
    }
}

