/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.freemarker;

import edu.cornell.mannlib.vitro.webapp.i18n.TranslationProvider;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.DeepUnwrap;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nStringTemplateModel
implements TemplateMethodModelEx,
TemplateScalarModel {
    private static final Log log = LogFactory.getLog(I18nStringTemplateModel.class);
    private final String key;
    private final String textString;

    public I18nStringTemplateModel(String key, String textString) {
        this.key = key;
        this.textString = textString;
    }

    public String getAsString() throws TemplateModelException {
        return this.textString;
    }

    public Object exec(List args) throws TemplateModelException {
        log.debug((Object)("Formatting string '" + this.key + "' with these arguments: " + args));
        if (args.isEmpty()) {
            return this.textString;
        }
        Object[] unwrappedArgs = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            unwrappedArgs[i] = DeepUnwrap.unwrap((TemplateModel)((TemplateModel)args.get(i)));
        }
        try {
            if (I18nStringTemplateModel.isOnlineTranslationsEnabled()) {
                return this.getOnlineTranslationsFormattedMessage(this.textString, unwrappedArgs);
            }
            return MessageFormat.format(TranslationProvider.preprocessForFormating(this.textString), unwrappedArgs);
        }
        catch (Exception e) {
            String message = "Can't format '" + this.key + "', wrong argument types: " + args + " for message format'" + this.textString + "'";
            log.warn((Object)message);
            return message;
        }
    }

    private String getOnlineTranslationsFormattedMessage(String preProcessed, Object[] args) {
        CharSequence[] parts = preProcessed.split("\u25a6");
        int messageIndex = parts.length - 1;
        String message = MessageFormat.format(TranslationProvider.preprocessForFormating(parts[messageIndex]), args);
        CharSequence[] arguments = this.convertToArrayOfStrings(args);
        parts[messageIndex] = "";
        String result = String.join((CharSequence)"\u25a6", parts) + String.join((CharSequence)"\u25a6", arguments) + "\u25a6" + message;
        return result;
    }

    private String[] convertToArrayOfStrings(Object[] args) {
        String[] result = new String[args.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = args[i] != null ? args[i].toString() : "";
        }
        return result;
    }

    private static boolean isOnlineTranslationsEnabled() {
        return DeveloperSettings.getInstance().getBoolean(Key.I18N_ONLINE_TRANSLATION);
    }
}

