/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nLogger {
    private static final Log log = LogFactory.getLog(I18nLogger.class);
    private DeveloperSettings settings = DeveloperSettings.getInstance();

    public void log(String key, Object[] parameters, String rawText, String formattedText) {
        if (this.isI18nLoggingTurnedOn()) {
            String message = String.format("Retrieved from %s with %s: '%s'", key, Arrays.toString(parameters), rawText);
            if (!rawText.equals(formattedText)) {
                message = message + String.format(" --> '%s'", formattedText);
            }
            log.info((Object)message);
        }
    }

    private boolean isI18nLoggingTurnedOn() {
        return this.settings.getBoolean(Key.I18N_LOG_STRINGS) && log.isInfoEnabled();
    }
}

